/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.util;

import com.corosus.coroutil.config.ConfigCoroUtil;
import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilCompatibility;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class CoroUtilPath {
    public static boolean tryMoveToEntityLivingLongDist(MobEntity entSource, Entity entityTo, double moveSpeedAmp) {
        return CoroUtilPath.tryMoveToXYZLongDist(entSource, entityTo.func_226277_ct_(), entityTo.func_174813_aQ().field_72338_b, entityTo.func_226281_cx_(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(MobEntity ent, double x, double y, double z, double moveSpeedAmp) {
        boolean success;
        block12: {
            World world = ent.field_70170_p;
            success = false;
            try {
                int tries;
                int gatherZ;
                int gatherY;
                double followDist;
                if (!ent.func_70661_as().func_75500_f()) break block12;
                double distToPlayer = Math.sqrt(ent.func_70092_e(x, y, z));
                if (distToPlayer <= (followDist = ent.func_110148_a(Attributes.field_233819_b_).func_111126_e())) {
                    success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), moveSpeedAmp);
                    break block12;
                }
                double d = x + 0.5 - ent.func_226277_ct_();
                double d2 = z + 0.5 - ent.func_226281_cx_();
                double d1 = y + 0.5 - (ent.func_226278_cu_() + (double)ent.func_70047_e());
                double d3 = MathHelper.func_76129_c((float)((float)(d * d + d2 * d2)));
                float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
                float rotationPitch = -f3;
                float rotationYaw = f2;
                MobEntity center = ent;
                Random rand = new Random();
                float randLook = rand.nextInt(90) - 45;
                double dist = followDist * 0.75 + (double)rand.nextInt((int)followDist / 2);
                int gatherX = (int)Math.floor(center.func_226277_ct_() + -Math.sin((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                BlockPos pos = new BlockPos(gatherX, gatherY = (int)center.func_226278_cu_(), gatherZ = (int)Math.floor(center.func_226281_cx_() + Math.cos((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist));
                if (!world.func_195588_v(pos)) {
                    return false;
                }
                BlockState state = world.func_180495_p(pos);
                if (!CoroUtilBlock.isAir(state.func_177230_c())) {
                    int offset = -5;
                    for (tries = 0; tries < 30 && !CoroUtilBlock.isAir(state.func_177230_c()) && state.func_196957_g((IBlockReader)ent.field_70170_p, pos, PathType.LAND); ++tries) {
                        pos = new BlockPos(gatherX, gatherY += offset++, gatherZ);
                        state = world.func_180495_p(pos);
                    }
                } else {
                    while (tries < 30 && (CoroUtilBlock.isAir(state.func_177230_c()) || !state.func_196957_g((IBlockReader)ent.field_70170_p, pos, PathType.LAND))) {
                        pos = new BlockPos(gatherX, --gatherY, gatherZ);
                        state = world.func_180495_p(pos);
                        ++tries;
                    }
                }
                if (tries < 30) {
                    success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, gatherX, gatherY, gatherZ, moveSpeedAmp);
                } else {
                    if (!world.func_195588_v(pos = new BlockPos(pos.func_177958_n(), world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177958_n(), pos.func_177952_p()), pos.func_177952_p()).func_177977_b())) {
                        return false;
                    }
                    state = world.func_180495_p(pos);
                    if (state.func_196957_g((IBlockReader)ent.field_70170_p, pos, PathType.LAND)) {
                        success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), moveSpeedAmp);
                    }
                }
            }
            catch (Exception ex) {
                CULog.err("Exception trying to pathfind");
                if (!ConfigCoroUtil.useLoggingError) break block12;
                ex.printStackTrace();
            }
        }
        return success;
    }
}

