/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CrossSideManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ServerVoiceEvents {
    private final Map<UUID, Integer> clientCompatibilities = new ConcurrentHashMap<UUID, Integer>();
    private Server server;

    public ServerVoiceEvents() {
        CommonCompatibilityManager.INSTANCE.onServerStarting(this::serverStarting);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedIn(this::playerLoggedIn);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedOut(this::playerLoggedOut);
        CommonCompatibilityManager.INSTANCE.onServerStopping(this::serverStopping);
        CommonCompatibilityManager.INSTANCE.onServerVoiceChatConnected(this::serverVoiceChatConnected);
        CommonCompatibilityManager.INSTANCE.onServerVoiceChatDisconnected(this::serverVoiceChatDisconnected);
        CommonCompatibilityManager.INSTANCE.onPlayerCompatibilityCheckSucceeded(this::playerCompatibilityCheckSucceeded);
        CommonCompatibilityManager.INSTANCE.getNetManager().requestSecretChannel.setServerListener((server, player, handler, packet) -> {
            Voicechat.LOGGER.info("Received secret request of {} ({})", player.func_200200_C_().getString(), packet.getCompatibilityVersion());
            this.clientCompatibilities.put(player.func_110124_au(), packet.getCompatibilityVersion());
            if (packet.getCompatibilityVersion() != Voicechat.COMPATIBILITY_VERSION) {
                Voicechat.LOGGER.warn("Connected client {} has incompatible voice chat version (server={}, client={})", player.func_200200_C_().getString(), Voicechat.COMPATIBILITY_VERSION, packet.getCompatibilityVersion());
                player.func_145747_a(this.getIncompatibleMessage(packet.getCompatibilityVersion()), Util.field_240973_b_);
            } else {
                this.initializePlayerConnection(player);
            }
        });
    }

    public ITextComponent getIncompatibleMessage(int clientCompatibilityVersion) {
        if (clientCompatibilityVersion <= 6) {
            return new StringTextComponent(String.format(Voicechat.TRANSLATIONS.voicechatNotCompatibleMessage.get(), CommonCompatibilityManager.INSTANCE.getModVersion(), CommonCompatibilityManager.INSTANCE.getModName()));
        }
        return new TranslationTextComponent("message.voicechat.incompatible_version", new Object[]{new StringTextComponent(CommonCompatibilityManager.INSTANCE.getModVersion()).func_240699_a_(TextFormatting.BOLD), new StringTextComponent(CommonCompatibilityManager.INSTANCE.getModName()).func_240699_a_(TextFormatting.BOLD)});
    }

    public boolean isCompatible(ServerPlayerEntity player) {
        return this.isCompatible(player.func_110124_au());
    }

    public boolean isCompatible(UUID playerUuid) {
        return this.clientCompatibilities.getOrDefault(playerUuid, -1) == Voicechat.COMPATIBILITY_VERSION;
    }

    public void serverStarting(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
        if (!CrossSideManager.get().shouldRunVoiceChatServer(mcServer)) {
            Voicechat.LOGGER.info("Disabling voice chat in singleplayer", new Object[0]);
            return;
        }
        if (mcServer instanceof DedicatedServer && !mcServer.func_71266_T()) {
            Voicechat.LOGGER.warn("Running in offline mode - Voice chat encryption is not secure!", new Object[0]);
        }
        try {
            this.server = new Server(mcServer);
            this.server.start();
            PluginManager.instance().onServerStarted();
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to start voice chat server", e);
        }
    }

    public void initializePlayerConnection(ServerPlayerEntity player) {
        if (this.server == null) {
            return;
        }
        CommonCompatibilityManager.INSTANCE.emitPlayerCompatibilityCheckSucceeded(player);
        UUID secret = this.server.generateNewSecret(player.func_110124_au());
        if (secret == null) {
            Voicechat.LOGGER.warn("Player already requested secret - ignoring", new Object[0]);
            return;
        }
        NetManager.sendToClient(player, new SecretPacket(player, secret, this.server.getPort(), Voicechat.SERVER_CONFIG));
        Voicechat.LOGGER.info("Sent secret to {}", player.func_200200_C_().getString());
    }

    public void playerLoggedIn(final ServerPlayerEntity serverPlayer) {
        if (this.server != null) {
            this.server.onPlayerLoggedIn(serverPlayer);
        }
        if (!Voicechat.SERVER_CONFIG.forceVoiceChat.get().booleanValue()) {
            return;
        }
        final Timer timer = new Timer(serverPlayer.func_146103_bH().getName() + "%s-login-timer", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                timer.cancel();
                timer.purge();
                if (!serverPlayer.field_71133_b.func_71278_l()) {
                    return;
                }
                if (!serverPlayer.field_71135_a.field_147371_a.func_150724_d()) {
                    return;
                }
                if (!ServerVoiceEvents.this.isCompatible(serverPlayer)) {
                    serverPlayer.field_71133_b.execute(() -> serverPlayer2.field_71135_a.func_194028_b((ITextComponent)new StringTextComponent(String.format(Voicechat.TRANSLATIONS.forceVoicechatKickMessage.get(), CommonCompatibilityManager.INSTANCE.getModName(), CommonCompatibilityManager.INSTANCE.getModVersion()))));
                }
            }
        }, Voicechat.SERVER_CONFIG.loginTimeout.get().intValue());
    }

    public void playerLoggedOut(ServerPlayerEntity player) {
        this.clientCompatibilities.remove(player.func_110124_au());
        if (this.server == null) {
            return;
        }
        this.server.onPlayerLoggedOut(player);
        Voicechat.LOGGER.info("Disconnecting client {}", player.func_200200_C_().getString());
    }

    public void serverVoiceChatConnected(ServerPlayerEntity serverPlayer) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerVoicechatConnect(serverPlayer);
    }

    public void serverVoiceChatDisconnected(UUID uuid) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerVoicechatDisconnect(uuid);
    }

    public void playerCompatibilityCheckSucceeded(ServerPlayerEntity player) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerCompatibilityCheckSucceeded(player);
    }

    @Nullable
    public Server getServer() {
        return this.server;
    }

    public void serverStopping(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }
}

