/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client.speaker;

import de.maxhenkel.voicechat.voice.client.PositionalAudioUtils;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.speaker.ALSpeakerBase;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.openal.AL11;

public class FakeALSpeaker
extends ALSpeakerBase {
    public FakeALSpeaker(SoundManager soundManager, int sampleRate, int bufferSize, @Nullable UUID audioChannelId) {
        super(soundManager, sampleRate, bufferSize, audioChannelId);
        this.bufferSize *= 2;
    }

    @Override
    protected void openSync() {
        super.openSync();
        AL11.alDistanceModel((int)0);
        SoundManager.checkAlError();
    }

    @Override
    protected short[] convert(short[] data, @Nullable Vector3d position) {
        return PositionalAudioUtils.convertToStereo(data, position);
    }

    @Override
    protected int getFormat() {
        return 4355;
    }

    @Override
    protected void setPositionSync(@Nullable Vector3d soundPos, float maxDistance) {
    }

    @Override
    protected float getVolume(float volume, @Nullable Vector3d position, float maxDistance) {
        if (position == null) {
            return super.getVolume(volume, position, maxDistance);
        }
        return super.getVolume(volume, position, maxDistance) * PositionalAudioUtils.getDistanceVolume(maxDistance, position);
    }

    @Override
    protected int getBufferSize() {
        return Math.min(super.getBufferSize(), 3);
    }

    @Override
    protected void linearAttenuation(float maxDistance) {
    }
}

