/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreen;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingManager;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class KeyEvents {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    public static KeyBinding KEY_PTT;
    public static KeyBinding KEY_WHISPER;
    public static KeyBinding KEY_MUTE;
    public static KeyBinding KEY_DISABLE;
    public static KeyBinding KEY_HIDE_ICONS;
    public static KeyBinding KEY_VOICE_CHAT;
    public static KeyBinding KEY_VOICE_CHAT_SETTINGS;
    public static KeyBinding KEY_GROUP;
    public static KeyBinding KEY_TOGGLE_RECORDING;
    public static KeyBinding KEY_ADJUST_VOLUMES;
    public static KeyBinding[] ALL_KEYS;

    public KeyEvents() {
        ClientCompatibilityManager.INSTANCE.onHandleKeyBinds(this::handleKeybinds);
        KEY_PTT = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.push_to_talk", InputMappings.field_197958_a.func_197937_c(), "key.categories.voicechat"));
        KEY_WHISPER = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.whisper", InputMappings.field_197958_a.func_197937_c(), "key.categories.voicechat"));
        KEY_MUTE = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.mute_microphone", 77, "key.categories.voicechat"));
        KEY_DISABLE = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.disable_voice_chat", 78, "key.categories.voicechat"));
        KEY_HIDE_ICONS = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.hide_icons", 72, "key.categories.voicechat"));
        KEY_VOICE_CHAT = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat", 86, "key.categories.voicechat"));
        KEY_VOICE_CHAT_SETTINGS = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat_settings", InputMappings.field_197958_a.func_197937_c(), "key.categories.voicechat"));
        KEY_GROUP = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat_group", 71, "key.categories.voicechat"));
        KEY_TOGGLE_RECORDING = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat_toggle_recording", InputMappings.field_197958_a.func_197937_c(), "key.categories.voicechat"));
        KEY_ADJUST_VOLUMES = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyBinding("key.voice_chat_adjust_volumes", InputMappings.field_197958_a.func_197937_c(), "key.categories.voicechat"));
        ALL_KEYS = new KeyBinding[]{KEY_PTT, KEY_WHISPER, KEY_MUTE, KEY_DISABLE, KEY_HIDE_ICONS, KEY_VOICE_CHAT, KEY_VOICE_CHAT_SETTINGS, KEY_GROUP, KEY_TOGGLE_RECORDING, KEY_ADJUST_VOLUMES};
    }

    private void handleKeybinds() {
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        if (OnboardingManager.isOnboarding()) {
            for (KeyBinding allKey : ALL_KEYS) {
                if (!allKey.func_151468_f()) continue;
                OnboardingManager.startOnboarding(null);
                return;
            }
            return;
        }
        ClientVoicechat client = ClientManager.getClient();
        ClientPlayerStateManager playerStateManager = ClientManager.getPlayerStateManager();
        if (KEY_VOICE_CHAT.func_151468_f()) {
            if (Screen.func_231174_t_()) {
                if (Screen.func_231172_r_()) {
                    VoicechatClient.CLIENT_CONFIG.onboardingFinished.set(false).save();
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.voicechat.onboarding.reset"), true);
                } else {
                    ClientManager.getDebugOverlay().toggle();
                }
            } else {
                this.minecraft.func_147108_a((Screen)new VoiceChatScreen());
            }
        }
        if (KEY_GROUP.func_151468_f()) {
            if (client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled()) {
                ClientGroup group = playerStateManager.getGroup();
                if (group != null) {
                    this.minecraft.func_147108_a((Screen)new GroupScreen(group));
                } else {
                    this.minecraft.func_147108_a((Screen)new JoinGroupScreen());
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.voicechat.groups_disabled"), true);
            }
        }
        if (KEY_VOICE_CHAT_SETTINGS.func_151468_f()) {
            this.minecraft.func_147108_a((Screen)new VoiceChatSettingsScreen());
        }
        if (KEY_ADJUST_VOLUMES.func_151468_f()) {
            this.minecraft.func_147108_a((Screen)new AdjustVolumesScreen());
        }
        if (KEY_PTT.func_151468_f()) {
            this.checkConnected();
        }
        if (KEY_WHISPER.func_151468_f()) {
            this.checkConnected();
        }
        if (KEY_MUTE.func_151468_f()) {
            playerStateManager.setMuted(!playerStateManager.isMuted());
        }
        if (KEY_DISABLE.func_151468_f()) {
            playerStateManager.setDisabled(!playerStateManager.isDisabled());
        }
        if (KEY_TOGGLE_RECORDING.func_151468_f() && client != null) {
            ClientManager.getClient().toggleRecording();
        }
        if (KEY_HIDE_ICONS.func_151468_f()) {
            boolean hidden = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
            VoicechatClient.CLIENT_CONFIG.hideIcons.set(hidden).save();
            if (hidden) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.voicechat.icons_hidden"), true);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.voicechat.icons_visible"), true);
            }
        }
    }

    private boolean checkConnected() {
        if (ClientManager.getClient() == null || ClientManager.getClient().getConnection() == null || !ClientManager.getClient().getConnection().isInitialized()) {
            this.sendNotConnectedMessage();
            return false;
        }
        return true;
    }

    private void sendNotConnectedMessage() {
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        if (player == null) {
            Voicechat.LOGGER.warn("Voice chat not connected", new Object[0]);
            return;
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_not_connected"), true);
    }
}

