/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;

public class GroupChatManager {
    private static final ResourceLocation TALK_OUTLINE = new ResourceLocation("voicechat", "textures/icons/talk_outline.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = new ResourceLocation("voicechat", "textures/icons/speaker_small_off.png");

    public static void renderIcons(MatrixStack matrixStack) {
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        List<PlayerState> groupMembers = GroupChatManager.getGroupMembers(VoicechatClient.CLIENT_CONFIG.showOwnGroupIcon.get());
        matrixStack.func_227860_a_();
        int posX = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosY.get();
        if (posX < 0) {
            matrixStack.func_227861_a_((double)mc.func_228018_at_().func_198107_o(), 0.0, 0.0);
        }
        if (posY < 0) {
            matrixStack.func_227861_a_(0.0, (double)mc.func_228018_at_().func_198087_p(), 0.0);
        }
        matrixStack.func_227861_a_((double)posX, (double)posY, 0.0);
        float scale = VoicechatClient.CLIENT_CONFIG.groupHudIconScale.get().floatValue();
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        boolean vertical = VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.get().equals((Object)GroupPlayerIconOrientation.VERTICAL);
        for (int i = 0; i < groupMembers.size(); ++i) {
            PlayerState state = groupMembers.get(i);
            matrixStack.func_227860_a_();
            if (vertical) {
                if (posY < 0) {
                    matrixStack.func_227861_a_(0.0, (double)i * -11.0, 0.0);
                } else {
                    matrixStack.func_227861_a_(0.0, (double)i * 11.0, 0.0);
                }
            } else if (posX < 0) {
                matrixStack.func_227861_a_((double)i * -11.0, 0.0, 0.0);
            } else {
                matrixStack.func_227861_a_((double)i * 11.0, 0.0, 0.0);
            }
            if (client.getTalkCache().isTalking(state.getUuid())) {
                mc.func_110434_K().func_110577_a(TALK_OUTLINE);
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)(posX < 0 ? -10 : 0), (int)(posY < 0 ? -10 : 0), (float)0.0f, (float)0.0f, (int)10, (int)10, (int)16, (int)16);
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            mc.func_110434_K().func_110577_a(GameProfileUtils.getSkin(state.getUuid()));
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(posX < 0 ? -9 : 1), (int)(posY < 0 ? -9 : 1), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(posX < 0 ? -9 : 1), (int)(posY < 0 ? -9 : 1), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            if (state.isDisabled()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(posX < 0 ? -9.0 : 1.0, posY < 0 ? -9.0 : 1.0, 0.0);
                matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
                mc.func_110434_K().func_110577_a(SPEAKER_OFF_ICON);
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    public static List<PlayerState> getGroupMembers() {
        return GroupChatManager.getGroupMembers(true);
    }

    public static List<PlayerState> getGroupMembers(boolean includeSelf) {
        ArrayList<PlayerState> entries = new ArrayList<PlayerState>();
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            return entries;
        }
        for (PlayerState state : ClientManager.getPlayerStateManager().getPlayerStates(includeSelf)) {
            if (!state.hasGroup() || !state.getGroup().equals(group)) continue;
            entries.add(state);
        }
        entries.sort(Comparator.comparing(PlayerState::getName));
        return entries;
    }
}

