/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.resourcepacks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.maxhenkel.voicechat.Voicechat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;

public class VoiceChatResourcePack
extends ResourcePack {
    protected String path;
    protected TextComponent name;

    public VoiceChatResourcePack(String path, TextComponent name) {
        super(null);
        this.path = path;
        this.name = name;
    }

    @Nullable
    public ResourcePackInfo toPack() {
        try {
            PackMetadataSection packMetadataSection = (PackMetadataSection)this.func_195760_a((IMetadataSectionSerializer)PackMetadataSection.field_198964_a);
            if (packMetadataSection == null) {
                return null;
            }
            return new ResourcePackInfo(this.path, false, () -> this, (ITextComponent)this.name, packMetadataSection.func_198963_a(), PackCompatibility.COMPATIBLE, ResourcePackInfo.Priority.TOP, false, IPackNameDecorator.field_232626_b_);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String func_195762_a() {
        return this.path;
    }

    private String getPath() {
        return "/packs/" + this.path + "/";
    }

    @Nullable
    private InputStream get(String name) {
        return Voicechat.class.getResourceAsStream(this.getPath() + name);
    }

    protected InputStream func_195766_a(String name) throws IOException {
        InputStream resourceAsStream = this.get(name);
        if (resourceAsStream == null) {
            throw new FileNotFoundException("Resource " + name + " does not exist");
        }
        return resourceAsStream;
    }

    protected boolean func_195768_c(String name) {
        try {
            return this.get(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        ArrayList list = Lists.newArrayList();
        try {
            URL url = Voicechat.class.getResource(this.getPath());
            Path namespacePath = Paths.get(url.toURI()).resolve(type.func_198956_a()).resolve(namespace);
            Path resPath = namespacePath.resolve(prefix);
            if (!Files.exists(resPath, new LinkOption[0])) {
                return list;
            }
            try (Stream<Path> files = Files.walk(resPath, new FileVisitOption[0]);){
                files.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ResourceLocation resourceLocation = new ResourceLocation(namespace, VoiceChatResourcePack.convertPath(path).substring(VoiceChatResourcePack.convertPath(namespacePath).length() + 1));
                    list.add(resourceLocation);
                });
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to list builtin pack resources", e);
        }
        return list.stream().filter(resourceLocation -> pathFilter.test(resourceLocation.func_110623_a())).collect(Collectors.toList());
    }

    private static String convertPath(Path path) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < path.getNameCount(); ++i) {
            stringBuilder.append(path.getName(i));
            if (i >= path.getNameCount() - 1) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public Set<String> func_195759_a(ResourcePackType packType) {
        if (packType == ResourcePackType.CLIENT_RESOURCES) {
            return ImmutableSet.of((Object)"voicechat");
        }
        return ImmutableSet.of();
    }

    public void close() {
    }
}

