/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.events.ServerVoiceChatConnectedEvent;
import de.maxhenkel.voicechat.events.ServerVoiceChatDisconnectedEvent;
import de.maxhenkel.voicechat.events.VoiceChatCompatibilityCheckSucceededEvent;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.ForgeNetManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.permission.ForgePermissionManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;

public class ForgeCommonCompatibilityManager
extends CommonCompatibilityManager {
    private final List<Consumer<MinecraftServer>> serverStartingEvents = new CopyOnWriteArrayList<Consumer<MinecraftServer>>();
    private final List<Consumer<MinecraftServer>> serverStoppingEvents = new CopyOnWriteArrayList<Consumer<MinecraftServer>>();
    private final List<Consumer<CommandDispatcher<CommandSource>>> registerServerCommandsEvents = new CopyOnWriteArrayList<Consumer<CommandDispatcher<CommandSource>>>();
    private final List<Consumer<ServerPlayerEntity>> playerLoggedInEvents = new CopyOnWriteArrayList<Consumer<ServerPlayerEntity>>();
    private final List<Consumer<ServerPlayerEntity>> playerLoggedOutEvents = new CopyOnWriteArrayList<Consumer<ServerPlayerEntity>>();
    private final List<Consumer<ServerPlayerEntity>> voicechatConnectEvents = new CopyOnWriteArrayList<Consumer<ServerPlayerEntity>>();
    private final List<Consumer<ServerPlayerEntity>> voicechatCompatibilityCheckSucceededEvents = new CopyOnWriteArrayList<Consumer<ServerPlayerEntity>>();
    private final List<Consumer<UUID>> voicechatDisconnectEvents = new CopyOnWriteArrayList<Consumer<UUID>>();
    private ForgeNetManager netManager;

    @SubscribeEvent
    public void serverStarting(FMLServerStartedEvent event) {
        this.serverStartingEvents.forEach(consumer -> consumer.accept(event.getServer()));
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppingEvent event) {
        this.serverStoppingEvents.forEach(consumer -> consumer.accept(event.getServer()));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        this.registerServerCommandsEvents.forEach(consumer -> consumer.accept(event.getDispatcher()));
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            this.playerLoggedInEvents.forEach(consumer -> consumer.accept(player));
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            this.playerLoggedOutEvents.forEach(consumer -> consumer.accept(player));
        }
    }

    @Override
    public String getModVersion() {
        return ((ModContainer)ModList.get().getModContainerById("voicechat").get()).getModInfo().getVersion().toString();
    }

    @Override
    public String getModName() {
        return ModList.get().getMods().stream().filter(info -> info.getModId().equals("voicechat")).findAny().map(IModInfo::getDisplayName).orElse("voicechat");
    }

    @Override
    public Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public void emitServerVoiceChatConnectedEvent(ServerPlayerEntity player) {
        this.voicechatConnectEvents.forEach(consumer -> consumer.accept(player));
        MinecraftForge.EVENT_BUS.post((Event)new ServerVoiceChatConnectedEvent(player));
    }

    @Override
    public void emitServerVoiceChatDisconnectedEvent(UUID clientID) {
        this.voicechatDisconnectEvents.forEach(consumer -> consumer.accept(clientID));
        MinecraftForge.EVENT_BUS.post((Event)new ServerVoiceChatDisconnectedEvent(clientID));
    }

    @Override
    public void emitPlayerCompatibilityCheckSucceeded(ServerPlayerEntity player) {
        this.voicechatCompatibilityCheckSucceededEvents.forEach(consumer -> consumer.accept(player));
        MinecraftForge.EVENT_BUS.post((Event)new VoiceChatCompatibilityCheckSucceededEvent(player));
    }

    @Override
    public void onServerVoiceChatConnected(Consumer<ServerPlayerEntity> onVoiceChatConnected) {
        this.voicechatConnectEvents.add(onVoiceChatConnected);
    }

    @Override
    public void onServerVoiceChatDisconnected(Consumer<UUID> onVoiceChatDisconnected) {
        this.voicechatDisconnectEvents.add(onVoiceChatDisconnected);
    }

    @Override
    public void onServerStarting(Consumer<MinecraftServer> onServerStarting) {
        this.serverStartingEvents.add(onServerStarting);
    }

    @Override
    public void onServerStopping(Consumer<MinecraftServer> onServerStopping) {
        this.serverStoppingEvents.add(onServerStopping);
    }

    @Override
    public void onPlayerLoggedIn(Consumer<ServerPlayerEntity> onPlayerLoggedIn) {
        this.playerLoggedInEvents.add(onPlayerLoggedIn);
    }

    @Override
    public void onPlayerLoggedOut(Consumer<ServerPlayerEntity> onPlayerLoggedOut) {
        this.playerLoggedOutEvents.add(onPlayerLoggedOut);
    }

    @Override
    public void onPlayerCompatibilityCheckSucceeded(Consumer<ServerPlayerEntity> onPlayerCompatibilityCheckSucceeded) {
        this.voicechatCompatibilityCheckSucceededEvents.add(onPlayerCompatibilityCheckSucceeded);
    }

    @Override
    public void onRegisterServerCommands(Consumer<CommandDispatcher<CommandSource>> onRegisterServerCommands) {
        this.registerServerCommandsEvents.add(onRegisterServerCommands);
    }

    @Override
    public NetManager getNetManager() {
        if (this.netManager == null) {
            this.netManager = new ForgeNetManager();
        }
        return this.netManager;
    }

    @Override
    public boolean isDevEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist().isDedicatedServer();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public List<VoicechatPlugin> loadPlugins() {
        ArrayList<VoicechatPlugin> plugins = new ArrayList<VoicechatPlugin>();
        ModList.get().getAllScanData().forEach(scan -> scan.getAnnotations().forEach(annotationData -> {
            if (annotationData.getAnnotationType().getClassName().equals(ForgeVoicechatPlugin.class.getName())) {
                try {
                    Class<?> clazz = Class.forName(annotationData.getMemberName());
                    if (VoicechatPlugin.class.isAssignableFrom(clazz)) {
                        VoicechatPlugin plugin = (VoicechatPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        plugins.add(plugin);
                    }
                }
                catch (Throwable e) {
                    Voicechat.LOGGER.warn("Failed to load plugin '{}'", annotationData.getMemberName(), e);
                }
            }
        }));
        return plugins;
    }

    @Override
    public PermissionManager createPermissionManager() {
        return new ForgePermissionManager();
    }
}

