/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CategoryVolumeEntry
extends VolumeEntry {
    protected final VolumeCategoryImpl category;
    protected final ResourceLocation texture;

    public CategoryVolumeEntry(VolumeCategoryImpl category, AdjustVolumesScreen screen) {
        super(screen, new CategoryVolumeConfigEntry(category.getId()));
        this.category = category;
        this.texture = ClientManager.getCategoryManager().getTexture(category.getId(), OTHER_VOLUME_ICON);
    }

    public VolumeCategoryImpl getCategory() {
        return this.category;
    }

    @Override
    public void renderElement(MatrixStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        this.minecraft.func_110434_K().func_110577_a(this.texture);
        AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
        this.minecraft.field_71466_p.func_243248_b(poseStack, (ITextComponent)new StringTextComponent(this.category.getName()), (float)textX, (float)textY, PLAYER_NAME_COLOR);
        if (hovered && this.category.getDescription() != null) {
            this.screen.postRender(() -> this.screen.func_238652_a_(poseStack, (ITextComponent)new StringTextComponent(this.category.getDescription()), mouseX, mouseY));
        }
    }

    private static class CategoryVolumeConfigEntry
    implements AdjustVolumeSlider.VolumeConfigEntry {
        private final String category;

        public CategoryVolumeConfigEntry(String category) {
            this.category = category;
        }

        @Override
        public void save(double value) {
            VoicechatClient.VOLUME_CONFIG.setCategoryVolume(this.category, value);
            VoicechatClient.VOLUME_CONFIG.save();
        }

        @Override
        public double get() {
            return VoicechatClient.VOLUME_CONFIG.getCategoryVolume(this.category);
        }
    }
}

