/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.onboarding;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class OnboardingScreenBase
extends Screen {
    public static final ITextComponent NEXT = new TranslationTextComponent("message.voicechat.onboarding.next");
    public static final ITextComponent BACK = new TranslationTextComponent("message.voicechat.onboarding.back");
    public static final ITextComponent CANCEL = new TranslationTextComponent("message.voicechat.onboarding.cancel");
    protected static final int TEXT_COLOR = -1;
    protected static final int PADDING = 8;
    protected static final int SMALL_PADDING = 2;
    protected static final int BUTTON_HEIGHT = 20;
    protected int contentWidth;
    protected int guiLeft;
    protected int guiTop;
    protected int contentHeight;
    @Nullable
    protected Screen previous;

    public OnboardingScreenBase(ITextComponent title, @Nullable Screen previous) {
        super(title);
        this.previous = previous;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.contentWidth = this.field_230708_k_ / 2;
        this.guiLeft = (this.field_230708_k_ - this.contentWidth) / 2;
        this.guiTop = 20;
        this.contentHeight = this.field_230709_l_ - this.guiTop * 2;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    @Nullable
    public Screen getNextScreen() {
        return null;
    }

    protected void addPositiveButton(ITextComponent text, Button.IPressable onPress) {
        Button nextButton = new Button(this.guiLeft + this.contentWidth / 2 + 4, this.guiTop + this.contentHeight - 20, this.contentWidth / 2 - 4, 20, text, onPress);
        this.func_230480_a_((Widget)nextButton);
    }

    protected void addNextButton() {
        this.addPositiveButton(NEXT, button -> this.field_230706_i_.func_147108_a(this.getNextScreen()));
    }

    protected void addBackOrCancelButton(boolean big) {
        ITextComponent text = CANCEL;
        if (this.previous instanceof OnboardingScreenBase) {
            text = BACK;
        }
        Button cancel = new Button(this.guiLeft, this.guiTop + this.contentHeight - 20, big ? this.contentWidth : this.contentWidth / 2 - 4, 20, text, button -> this.field_230706_i_.func_147108_a(this.previous));
        this.func_230480_a_((Widget)cancel);
    }

    protected void addBackOrCancelButton() {
        this.addBackOrCancelButton(false);
    }

    protected void renderTitle(MatrixStack stack, ITextComponent titleComponent) {
        int titleWidth = this.field_230712_o_.func_238414_a_((ITextProperties)titleComponent);
        this.field_230712_o_.func_238407_a_(stack, titleComponent.func_241878_f(), (float)(this.field_230708_k_ / 2 - titleWidth / 2), (float)this.guiTop, -1);
    }

    protected void renderMultilineText(MatrixStack stack, ITextComponent textComponent) {
        List text = this.field_230712_o_.func_238425_b_((ITextProperties)textComponent, this.contentWidth);
        for (int i = 0; i < text.size(); ++i) {
            IReorderingProcessor line = (IReorderingProcessor)text.get(i);
            float f = this.field_230708_k_ / 2 - this.field_230712_o_.func_243245_a(line) / 2;
            this.field_230712_o_.getClass();
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238407_a_(stack, line, f, (float)(this.guiTop + 9 + 20 + i * (9 + 1)), -1);
        }
    }
}

