/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.gui.CreateGroupScreen;
import de.maxhenkel.voicechat.gui.EnterPasswordScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupEntry;
import de.maxhenkel.voicechat.gui.group.JoinGroupList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class JoinGroupScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_join_group.png");
    protected static final ITextComponent TITLE = new TranslationTextComponent("gui.voicechat.join_create_group.title");
    protected static final ITextComponent CREATE_GROUP = new TranslationTextComponent("message.voicechat.create_group_button");
    protected static final ITextComponent JOIN_CREATE_GROUP = new TranslationTextComponent("message.voicechat.join_create_group");
    protected static final ITextComponent NO_GROUPS = new TranslationTextComponent("message.voicechat.no_groups").func_240699_a_(TextFormatting.GRAY);
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected JoinGroupList groupList;
    protected Button createGroup;
    protected int units;

    public JoinGroupScreen() {
        super(TITLE, 236, 0);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = MathHelper.func_76123_f((float)2.2222223f);
        this.units = Math.max(minUnits, (this.field_230709_l_ - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        if (this.groupList != null) {
            this.groupList.updateSize(this.field_230708_k_, this.units * 18, this.guiTop + 16);
        } else {
            this.groupList = new JoinGroupList(this, this.field_230708_k_, this.units * 18, this.guiTop + 16, 36);
        }
        this.func_230481_d_((IGuiEventListener)this.groupList);
        this.createGroup = new Button(this.guiLeft + 7, this.guiTop + this.ySize - 20 - 7, this.xSize - 14, 20, CREATE_GROUP, button -> this.field_230706_i_.func_147108_a((Screen)new CreateGroupScreen()));
        this.func_230480_a_((Widget)this.createGroup);
    }

    @Override
    public void renderBackground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            this.func_238474_b_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        this.func_238474_b_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        this.func_238474_b_(poseStack, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        this.field_230712_o_.func_243248_b(poseStack, JOIN_CREATE_GROUP, (float)(this.guiLeft + this.xSize / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)JOIN_CREATE_GROUP) / 2), (float)(this.guiTop + 5), 0x404040);
        if (!this.groupList.isEmpty()) {
            this.groupList.func_230430_a_(poseStack, mouseX, mouseY, delta);
        } else {
            int n = this.field_230708_k_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            this.field_230712_o_.getClass();
            JoinGroupScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)NO_GROUPS, (int)n, (int)(n2 - 9 / 2), (int)-1);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        for (JoinGroupEntry entry : this.groupList.func_231039_at__()) {
            if (!entry.func_231047_b_(mouseX, mouseY)) continue;
            ClientGroup group = entry.getGroup().getGroup();
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (group.hasPassword()) {
                this.field_230706_i_.func_147108_a((Screen)new EnterPasswordScreen(group));
            } else {
                ClientServerNetManager.sendToServer(new JoinGroupPacket(group.getId(), null));
            }
            return true;
        }
        return false;
    }
}

