/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.group.GroupList;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideGroupHudTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Collections;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GroupScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_group.png");
    protected static final ResourceLocation LEAVE = new ResourceLocation("voicechat", "textures/icons/leave.png");
    protected static final ResourceLocation MICROPHONE = new ResourceLocation("voicechat", "textures/icons/microphone_button.png");
    protected static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/icons/speaker_button.png");
    protected static final ResourceLocation GROUP_HUD = new ResourceLocation("voicechat", "textures/icons/group_hud_button.png");
    protected static final ITextComponent TITLE = new TranslationTextComponent("gui.voicechat.group.title");
    protected static final ITextComponent LEAVE_GROUP = new TranslationTextComponent("message.voicechat.leave_group");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected GroupList groupList;
    protected int units;
    protected final ClientGroup group;
    protected ToggleImageButton mute;
    protected ToggleImageButton disable;
    protected ToggleImageButton showHUD;
    protected ImageButton leave;

    public GroupScreen(ClientGroup group) {
        super(TITLE, 236, 0);
        this.group = group;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = MathHelper.func_76123_f((float)2.2222223f);
        this.units = Math.max(minUnits, (this.field_230709_l_ - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();
        if (this.groupList != null) {
            this.groupList.updateSize(this.field_230708_k_, this.units * 18, this.guiTop + 16);
        } else {
            this.groupList = new GroupList(this, this.field_230708_k_, this.units * 18, this.guiTop + 16, 36);
        }
        this.func_230481_d_((IGuiEventListener)this.groupList);
        int buttonY = this.guiTop + this.ySize - 20 - 7;
        int buttonSize = 20;
        this.mute = new ToggleImageButton(this.guiLeft + 7, buttonY, MICROPHONE, stateManager::isMuted, button -> stateManager.setMuted(!stateManager.isMuted()), new MuteTooltipSupplier(this, stateManager));
        this.func_230480_a_((Widget)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 7 + buttonSize + 3, buttonY, SPEAKER, stateManager::isDisabled, button -> stateManager.setDisabled(!stateManager.isDisabled()), new DisableTooltipSupplier(this, stateManager));
        this.func_230480_a_((Widget)this.disable);
        this.showHUD = new ToggleImageButton(this.guiLeft + 7 + (buttonSize + 3) * 2, buttonY, GROUP_HUD, VoicechatClient.CLIENT_CONFIG.showGroupHUD::get, button -> VoicechatClient.CLIENT_CONFIG.showGroupHUD.set(VoicechatClient.CLIENT_CONFIG.showGroupHUD.get() == false).save(), new HideGroupHudTooltipSupplier(this));
        this.func_230480_a_((Widget)this.showHUD);
        this.leave = new ImageButton(this.guiLeft + this.xSize - buttonSize - 7, buttonY, LEAVE, button -> {
            ClientServerNetManager.sendToServer(new LeaveGroupPacket());
            this.field_230706_i_.func_147108_a((Screen)new JoinGroupScreen());
        }, (button, matrices, mouseX, mouseY) -> this.func_238654_b_(matrices, Collections.singletonList(LEAVE_GROUP.func_241878_f()), mouseX, mouseY));
        this.func_230480_a_((Widget)this.leave);
        this.checkButtons();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.field_230693_o_ = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE);
        this.showHUD.field_230693_o_ = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
    }

    @Override
    public void renderBackground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            this.func_238474_b_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        this.func_238474_b_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        this.func_238474_b_(poseStack, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        TranslationTextComponent title = this.group.getType().equals(Group.Type.NORMAL) ? new TranslationTextComponent("message.voicechat.group_title", new Object[]{new StringTextComponent(this.group.getName())}) : new TranslationTextComponent("message.voicechat.group_type_title", new Object[]{new StringTextComponent(this.group.getName()), GroupType.fromType(this.group.getType()).getTranslation()});
        this.field_230712_o_.func_243248_b(poseStack, (ITextComponent)title, (float)(this.guiLeft + this.xSize / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)title) / 2), (float)(this.guiTop + 5), 0x404040);
        this.groupList.func_230430_a_(poseStack, mouseX, mouseY, delta);
    }
}

