/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumeEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class GroupEntry
extends ListScreenEntryBase<GroupEntry> {
    protected static final ResourceLocation TALK_OUTLINE = new ResourceLocation("voicechat", "textures/icons/talk_outline.png");
    protected static final ResourceLocation SPEAKER_OFF = new ResourceLocation("voicechat", "textures/icons/speaker_small_off.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = ColorHelper.PackedColor.func_233006_a_((int)255, (int)74, (int)74, (int)74);
    protected static final int PLAYER_NAME_COLOR = ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255);
    protected final ListScreenBase parent;
    protected final Minecraft minecraft;
    protected PlayerState state;
    protected final AdjustVolumeSlider volumeSlider;

    public GroupEntry(ListScreenBase parent, PlayerState state) {
        this.parent = parent;
        this.minecraft = Minecraft.func_71410_x();
        this.state = state;
        this.volumeSlider = new AdjustVolumeSlider(0, 0, 100, 20, new PlayerVolumeEntry.PlayerVolumeConfigEntry(state.getUuid()));
        this.children.add(this.volumeSlider);
    }

    public void func_230432_a_(MatrixStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        ClientVoicechat client;
        AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL);
        poseStack.func_227860_a_();
        int outlineSize = height - 8;
        poseStack.func_227861_a_((double)(left + 4), (double)(top + 4), 0.0);
        float scale = (float)outlineSize / 10.0f;
        poseStack.func_227862_a_(scale, scale, scale);
        if (!this.state.isDisabled() && (client = ClientManager.getClient()) != null && client.getTalkCache().isTalking(this.state.getUuid())) {
            this.minecraft.func_110434_K().func_110577_a(TALK_OUTLINE);
            Screen.func_238463_a_((MatrixStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)10, (int)10, (int)16, (int)16);
        }
        this.minecraft.func_110434_K().func_110577_a(GameProfileUtils.getSkin(this.state.getUuid()));
        AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)1, (int)1, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.enableBlend();
        AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)1, (int)1, (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.disableBlend();
        if (this.state.isDisabled()) {
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(1.0, 1.0, 0.0);
            poseStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            this.minecraft.func_110434_K().func_110577_a(SPEAKER_OFF);
            Screen.func_238463_a_((MatrixStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            poseStack.func_227865_b_();
        }
        poseStack.func_227865_b_();
        StringTextComponent name = new StringTextComponent(this.state.getName());
        FontRenderer fontRenderer = this.minecraft.field_71466_p;
        float f = left + 4 + outlineSize + 4;
        int n = top + height / 2;
        this.minecraft.field_71466_p.getClass();
        fontRenderer.func_243248_b(poseStack, (ITextComponent)name, f, (float)(n - 9 / 2), PLAYER_NAME_COLOR);
        if (hovered && !ClientManager.getPlayerStateManager().getOwnID().equals(this.state.getUuid())) {
            this.volumeSlider.func_230991_b_(Math.min(width - (4 + outlineSize + 4 + this.minecraft.field_71466_p.func_238414_a_((ITextProperties)name) + 4 + 4), 100));
            this.volumeSlider.field_230690_l_ = left + (width - this.volumeSlider.func_230998_h_() - 4);
            this.volumeSlider.field_230691_m_ = top + (height - this.volumeSlider.func_238483_d_()) / 2;
            this.volumeSlider.func_230430_a_(poseStack, mouseX, mouseY, delta);
        }
    }

    public PlayerState getState() {
        return this.state;
    }

    public void setState(PlayerState state) {
        this.state = state;
    }
}

