/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class SelectDeviceScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_audio_devices.png");
    protected static final ITextComponent BACK = new TranslationTextComponent("message.voicechat.back");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    @Nullable
    protected Screen parent;
    protected AudioDeviceList deviceList;
    protected Button back;
    protected int units;

    public SelectDeviceScreen(ITextComponent title, @Nullable Screen parent) {
        super(title, 236, 0);
        this.parent = parent;
    }

    public abstract List<String> getDevices();

    public abstract ResourceLocation getIcon();

    public abstract ITextComponent getEmptyListComponent();

    public abstract ConfigEntry<String> getConfigEntry();

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = MathHelper.func_76123_f((float)2.2222223f);
        this.units = Math.max(minUnits, (this.field_230709_l_ - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        if (this.deviceList != null) {
            this.deviceList.updateSize(this.field_230708_k_, this.units * 18, this.guiTop + 16);
        } else {
            this.deviceList = new AudioDeviceList(this.field_230708_k_, this.units * 18, this.guiTop + 16).setIcon(this.getIcon()).setConfigEntry(this.getConfigEntry());
        }
        this.func_230481_d_((IGuiEventListener)this.deviceList);
        this.back = new Button(this.guiLeft + 7, this.guiTop + this.ySize - 20 - 7, this.xSize - 14, 20, BACK, button -> this.field_230706_i_.func_147108_a(this.parent));
        this.func_230480_a_((Widget)this.back);
        this.deviceList.setAudioDevices(this.getDevices());
    }

    @Override
    public void renderBackground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        if (this.isIngame()) {
            this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
            this.func_238474_b_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
            for (int i = 0; i < this.units; ++i) {
                this.func_238474_b_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
            }
            this.func_238474_b_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
            this.func_238474_b_(poseStack, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
        }
    }

    @Override
    public void renderForeground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        this.field_230712_o_.func_243248_b(poseStack, this.field_230704_d_, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2), (float)(this.guiTop + 5), this.isIngame() ? 0x404040 : TextFormatting.WHITE.func_211163_e());
        if (!this.deviceList.isEmpty()) {
            this.deviceList.func_230430_a_(poseStack, mouseX, mouseY, delta);
        } else {
            ITextComponent iTextComponent = this.getEmptyListComponent();
            int n = this.field_230708_k_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            this.field_230712_o_.getClass();
            SelectDeviceScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)iTextComponent, (int)n, (int)(n2 - 9 / 2), (int)-1);
        }
    }
}

