/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class VoiceChatScreenBase
extends Screen {
    public static final int FONT_COLOR = 0x404040;
    protected List<HoverArea> hoverAreas;
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;

    protected VoiceChatScreenBase(ITextComponent title, int xSize, int ySize) {
        super(title);
        this.xSize = xSize;
        this.ySize = ySize;
        this.hoverAreas = new ArrayList<HoverArea>();
    }

    protected void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(poseStack);
        this.renderBackground(poseStack, mouseX, mouseY, delta);
        super.func_230430_a_(poseStack, mouseX, mouseY, delta);
        this.renderForeground(poseStack, mouseX, mouseY, delta);
    }

    public void renderBackground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
    }

    public void renderForeground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    protected boolean isIngame() {
        return this.field_230706_i_.field_71441_e != null;
    }

    protected int getFontColor() {
        return this.isIngame() ? 0x404040 : TextFormatting.WHITE.func_211163_e();
    }

    public void drawHoverAreas(MatrixStack matrixStack, int mouseX, int mouseY) {
        for (HoverArea hoverArea : this.hoverAreas) {
            if (hoverArea.tooltip == null || !hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) continue;
            this.func_238654_b_(matrixStack, (List)hoverArea.tooltip.get(), mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    public static class HoverArea {
        private final int posX;
        private final int posY;
        private final int width;
        private final int height;
        @Nullable
        private final Supplier<List<IReorderingProcessor>> tooltip;

        public HoverArea(int posX, int posY, int width, int height) {
            this(posX, posY, width, height, null);
        }

        public HoverArea(int posX, int posY, int width, int height, Supplier<List<IReorderingProcessor>> tooltip) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.tooltip = tooltip;
        }

        public int getPosX() {
            return this.posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @Nullable
        public Supplier<List<IReorderingProcessor>> getTooltip() {
            return this.tooltip;
        }

        public boolean isHovered(int guiLeft, int guiTop, int mouseX, int mouseY) {
            return mouseX >= guiLeft + this.posX && mouseX < guiLeft + this.posX + this.width && mouseY >= guiTop + this.posY && mouseY < guiTop + this.posY + this.height;
        }
    }
}

