/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.sound;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundHandler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;

@OnlyIn(value=Dist.CLIENT)
public class SoundMuteHandler {
    private static Method calculateVolumeMethod = ObfuscationReflectionHelper.findMethod(SoundEngine.class, (String)"func_188770_e", (Class[])new Class[]{ISound.class});
    public static boolean isMuting = false;
    public static SoundEngine engine;
    public static SoundHandler handler;
    public static DecimalCurve muteGraph;
    public static int timeTick;
    private static Field playingSoundsChannelField;

    public static void tick() {
        if (isMuting) {
            double factor = muteGraph.valueAt((double)timeTick);
            if (factor <= 0.0) {
                SoundMuteHandler.endMuting();
            } else {
                SoundMuteHandler.setMuteVolume((float)(1.0 - factor));
                ++timeTick;
            }
        }
    }

    public static float getClampedVolume(float volume) {
        return volume * (isMuting ? (float)(1.0 - muteGraph.valueAt((double)timeTick)) : 1.0f);
    }

    public static Map<ISound, ChannelManager.Entry> getSounds() {
        try {
            return (Map)playingSoundsChannelField.get(engine);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setMuteVolume(float muteVolume) {
        if (!isMuting) {
            return;
        }
        SoundMuteHandler.getSounds().forEach((p_217926_1_, p_217926_2_) -> {
            try {
                float f = ((Float)calculateVolumeMethod.invoke((Object)engine, p_217926_1_)).floatValue();
                p_217926_2_.func_217888_a(p_217923_1_ -> p_217923_1_.func_216430_b(f));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    public static boolean startMuting(DecimalCurve muteGraph) {
        if (engine == null) {
            handler = Minecraft.func_71410_x().func_147118_V();
            engine = (SoundEngine)ObfuscationReflectionHelper.getPrivateValue(SoundHandler.class, (Object)handler, (String)"field_147694_f");
        }
        if (isMuting && SoundMuteHandler.muteGraph.valueAt((double)timeTick) > muteGraph.valueAt(0.0)) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            SoundMuteHandler.tick();
            return true;
        }
        if (!isMuting) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            isMuting = true;
            SoundMuteHandler.tick();
            return true;
        }
        return false;
    }

    public static void endMuting() {
        SoundMuteHandler.setMuteVolume(1.0f);
        isMuting = false;
    }

    static {
        timeTick = 0;
        playingSoundsChannelField = ObfuscationReflectionHelper.findField(SoundEngine.class, (String)"field_217942_m");
    }
}

