/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import team.creative.creativecore.common.config.premade.IntMinMax;
import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.creativecore.common.util.type.HashMapList;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Particle;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.common.event.EVEvents;
import team.creative.enhancedvisuals.common.visual.VisualRegistry;

public class VisualManager {
    private static Minecraft mc = Minecraft.func_71410_x();
    public static Random rand = new Random();
    private static HashMapList<VisualCategory, Visual> visuals = new HashMapList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onTick(@Nullable PlayerEntity player) {
        boolean areEyesInWater = player != null && EVEvents.areEyesInWater(player);
        HashMapList<VisualCategory, Visual> hashMapList = visuals;
        synchronized (hashMapList) {
            Iterator iterator = visuals.iterator();
            block3: while (iterator.hasNext()) {
                Visual visual = (Visual)iterator.next();
                int factor = 1;
                if (areEyesInWater && visual.isAffectedByWater()) {
                    factor = EnhancedVisuals.CONFIG.waterSubstractFactor;
                }
                for (int i = 0; i < factor; ++i) {
                    if (visual.tick()) continue;
                    visual.removeFromDisplay();
                    iterator.remove();
                    continue block3;
                }
            }
            for (VisualHandler handler : VisualRegistry.handlers()) {
                if (!handler.isEnabled(player)) continue;
                handler.tick(player);
            }
        }
        if (player != null && !player.func_70089_S()) {
            VisualManager.clearParticles();
        }
    }

    public static Collection<Visual> visuals(VisualCategory category) {
        return visuals.get((Object)category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearParticles() {
        HashMapList<VisualCategory, Visual> hashMapList = visuals;
        synchronized (hashMapList) {
            visuals.removeKey((Object)VisualCategory.particle);
        }
    }

    public static void add(Visual visual) {
        if (!visual.type.disabled) {
            visual.addToDisplay();
            visuals.add((Object)visual.getCategory(), (Object)visual);
        }
    }

    public static Visual addVisualFadeOut(VisualType vt, VisualHandler handler, IntMinMax time) {
        return VisualManager.addVisualFadeOut(vt, handler, (Curve)new DecimalCurve(0.0, 1.0, (double)time.next(rand), 0.0));
    }

    public static Visual addVisualFadeOut(VisualType vt, VisualHandler handler, int time) {
        return VisualManager.addVisualFadeOut(vt, handler, (Curve)new DecimalCurve(0.0, 1.0, (double)time, 0.0));
    }

    public static Visual addVisualFadeOut(VisualType vt, VisualHandler handler, Curve curve) {
        Visual v = new Visual(vt, handler, curve, vt.getVariantAmount() > 1 ? rand.nextInt(vt.getVariantAmount()) : 0);
        VisualManager.add(v);
        return v;
    }

    public static void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, IntMinMax time, boolean rotate) {
        VisualManager.addParticlesFadeOut(vt, handler, count, (Curve)new DecimalCurve(0.0, 1.0, (double)time.next(rand), 0.0), rotate, null);
    }

    public static void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, IntMinMax time, boolean rotate, Color color) {
        VisualManager.addParticlesFadeOut(vt, handler, count, (Curve)new DecimalCurve(0.0, 1.0, (double)time.next(rand), 0.0), rotate, color);
    }

    public static void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, int time, boolean rotate) {
        VisualManager.addParticlesFadeOut(vt, handler, count, (Curve)new DecimalCurve(0.0, 1.0, (double)time, 0.0), rotate, null);
    }

    public static void addParticlesFadeOut(VisualType vt, VisualHandler handler, int count, Curve curve, boolean rotate, Color color) {
        if (vt.disabled) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            int screenWidth = mc.func_228018_at_().func_198107_o();
            int screenHeight = mc.func_228018_at_().func_198087_p();
            int width = vt.getWidth(screenWidth);
            int height = vt.getHeight(screenHeight);
            if (vt.scaleVariants()) {
                double scale = vt.randomScale(rand);
                width = (int)((double)width * scale);
                height = (int)((double)height * scale);
            }
            Particle particle = new Particle(vt, handler, curve, VisualManager.generateOffset(rand, screenWidth, width), VisualManager.generateOffset(rand, screenHeight, height), width, height, rotate ? rand.nextFloat() * 360.0f : 0.0f, rand.nextInt(vt.getVariantAmount()));
            particle.color = color;
            VisualManager.add(particle);
        }
    }

    public static int generateOffset(Random rand, int dimensionLength, int spacingBuffer) {
        int half = dimensionLength / 2;
        float multiplier = (float)(1.0 - Math.pow(rand.nextDouble(), 2.0));
        float textureCenterPosition = rand.nextInt(2) == 0 ? (float)half + (float)half * multiplier : (float)half - (float)half * multiplier;
        return (int)(textureCenterPosition - (float)spacingBuffer / 2.0f);
    }
}

