/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.api;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.ICreativeConfig;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.sound.PositionedSound;
import team.creative.enhancedvisuals.client.sound.TickedSound;

public class VisualHandler
implements ICreativeConfig {
    @CreativeConfig
    public boolean enabled = true;
    @CreativeConfig
    @CreativeConfig.DecimalRange(max=1.0, min=0.0)
    public float opacity = 1.0f;

    public void configured(Dist side) {
    }

    public void tick(@Nullable PlayerEntity player) {
    }

    public boolean isEnabled(@Nullable PlayerEntity player) {
        return this.enabled && this.opacity > 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSound(ResourceLocation location) {
        this.playSound(location, null, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSound(ResourceLocation location, BlockPos pos) {
        this.playSound(location, pos, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSound(ResourceLocation location, float volume) {
        this.playSound(location, null, volume);
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSound(ResourceLocation location, BlockPos pos, float volume) {
        if (!EVClient.shouldRender()) {
            return;
        }
        if (pos != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSound(location, SoundCategory.MASTER, volume, 1.0f, pos));
        } else {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSound(location, SoundCategory.MASTER, volume, 1.0f));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void playSoundFadeOut(ResourceLocation location, BlockPos pos, DecimalCurve volume) {
        if (!EVClient.shouldRender()) {
            return;
        }
        if (pos != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new TickedSound(location, SoundCategory.MASTER, 1.0f, pos, volume));
        } else {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new TickedSound(location, SoundCategory.MASTER, 1.0f, volume));
        }
    }
}

