/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreenWarnings;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFLruCache;

public abstract class ETFUtils2 {
    public static ETFLruCache<ResourceLocation, NativeImage> KNOWN_NATIVE_IMAGES = new ETFLruCache();

    @Nullable
    public static ResourceLocation replaceIdentifier(ResourceLocation id, String regex, String replace) {
        ResourceLocation forReturn;
        if (id == null) {
            return null;
        }
        try {
            forReturn = new ResourceLocation(id.func_110624_b(), id.func_110623_a().replaceFirst(regex, replace));
        }
        catch (ResourceLocationException idFail) {
            ETFUtils2.logError(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.illegal_path_recommendation").getString() + "\n" + (Object)((Object)idFail));
            forReturn = null;
        }
        catch (Exception e) {
            forReturn = null;
        }
        return forReturn;
    }

    public static String returnNameOfHighestPackFromTheseMultiple(String[] packNameList) {
        ArrayList<String> packNames = new ArrayList<String>(Arrays.asList(packNameList));
        while (packNames.size() >= 2) {
            if (ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNames.get(0)) >= ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNames.get(1))) {
                packNames.remove(1);
                continue;
            }
            packNames.remove(0);
        }
        return packNames.get(0);
    }

    public static boolean isNativeImageEmpty(@NotNull NativeImage image) {
        boolean foundNonEmptyPixel = false;
        for (int x = 0; x < image.func_195702_a(); ++x) {
            for (int y = 0; y < image.func_195714_b(); ++y) {
                if (image.func_195709_a(x, y) == 0) continue;
                foundNonEmptyPixel = true;
                break;
            }
            if (foundNonEmptyPixel) break;
        }
        return !foundNonEmptyPixel;
    }

    @Nullable
    public static String returnNameOfHighestPackFromTheseTwo(String[] packNameList) {
        if (packNameList.length != 2) {
            ETFUtils2.logError("highest pack check failed");
            return null;
        }
        if (packNameList[0].equals(packNameList[1])) {
            return packNameList[0];
        }
        if (ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNameList[0]) >= ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNameList[1])) {
            return packNameList[0];
        }
        return packNameList[1];
    }

    @Nullable
    public static Properties readAndReturnPropertiesElseNull(ResourceLocation path) {
        Properties props = new Properties();
        try {
            IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(path);
            try {
                InputStream in = resource.func_199027_b();
                props.load(in);
                in.close();
                return props;
            }
            catch (Exception e) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object requireNonNullElseGet(Object one, Object two) {
        if (one == null) {
            return two;
        }
        return one;
    }

    public static NativeImage getNativeImageElseNull(@Nullable ResourceLocation identifier) {
        if (identifier != null && KNOWN_NATIVE_IMAGES.get(identifier) != null) {
            return KNOWN_NATIVE_IMAGES.get(identifier);
        }
        try {
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(identifier).func_199027_b();
            try {
                NativeImage img = NativeImage.func_195713_a((InputStream)in);
                in.close();
                KNOWN_NATIVE_IMAGES.put(identifier, img);
                return img;
            }
            catch (Exception e) {
                in.close();
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void logMessage(String obj) {
        ETFUtils2.logMessage(obj, false);
    }

    public static void logMessage(String obj, boolean inChat) {
        if (inChat) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.func_146105_b(ITextComponent.func_244388_a((String)("[INFO] [Entity Texture Features]: " + obj)), false);
            } else {
                ETFClientCommon.LOGGER.info(obj);
            }
        } else {
            ETFClientCommon.LOGGER.info(obj);
        }
    }

    public static void logWarn(String obj) {
        ETFUtils2.logWarn(obj, false);
    }

    public static void logWarn(String obj, boolean inChat) {
        if (inChat) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.func_146105_b(ITextComponent.func_244388_a((String)("[WARN] [Entity Texture Features]: " + obj)), false);
            } else {
                ETFClientCommon.LOGGER.warn(obj);
            }
        } else {
            ETFClientCommon.LOGGER.warn(obj);
        }
    }

    public static void logError(String obj) {
        ETFUtils2.logError(obj, false);
    }

    public static void logError(String obj, boolean inChat) {
        if (inChat) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.func_146105_b(ITextComponent.func_244388_a((String)("[ERROR] [Entity Texture Features]: " + obj)), false);
            } else {
                ETFClientCommon.LOGGER.error(obj);
            }
        } else {
            ETFClientCommon.LOGGER.error(obj);
        }
    }

    public static boolean isExistingResource(ResourceLocation identifier) {
        if (identifier == null) {
            return false;
        }
        if (ETFManager.getInstance().DOES_IDENTIFIER_EXIST_CACHED_RESULT.containsKey((Object)identifier)) {
            return ETFManager.getInstance().DOES_IDENTIFIER_EXIST_CACHED_RESULT.getBoolean((Object)identifier);
        }
        try {
            Minecraft.func_71410_x().func_195551_G().func_199002_a(identifier);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void saveConfig() {
        File config = new File(ETFClientCommon.CONFIG_DIR, "entity_texture_features.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.getParentFile().exists()) {
            config.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(config);
            fileWriter.write(gson.toJson((Object)ETFClientCommon.ETFConfigData));
            fileWriter.close();
        }
        catch (IOException e) {
            ETFUtils2.logError("Config file could not be saved", false);
        }
    }

    public static NativeImage emptyNativeImage() {
        return ETFUtils2.emptyNativeImage(64, 64);
    }

    public static NativeImage emptyNativeImage(int Width, int Height) {
        NativeImage empty = new NativeImage(Width, Height, false);
        empty.func_195715_a(0, 0, Width, Height, 0);
        return empty;
    }

    public static Integer[] getIntRange(String rawRange) {
        String[] split;
        if ((rawRange = rawRange.trim()).startsWith("-")) {
            rawRange = rawRange.replaceFirst("-", "N");
        }
        if ((split = (rawRange = rawRange.replaceAll("--", "-N")).split("-")).length > 1) {
            int[] minMax = new int[]{Integer.parseInt(split[0].replaceAll("\\D", "")), Integer.parseInt(split[1].replaceAll("\\D", ""))};
            if (split[0].contains("N")) {
                minMax[0] = -minMax[0];
            }
            if (split[1].contains("N")) {
                minMax[1] = -minMax[1];
            }
            ArrayList<Integer> builder = new ArrayList<Integer>();
            if (minMax[0] > minMax[1]) {
                minMax = new int[]{minMax[1], minMax[0]};
            }
            if (minMax[0] < minMax[1]) {
                for (int i = minMax[0]; i <= minMax[1]; ++i) {
                    builder.add(i);
                }
            } else {
                ETFUtils2.logMessage("Optifine properties failed to load: Texture heights range has a problem in properties file. this has occurred for value \"" + rawRange.replace("N", "-") + "\"", false);
            }
            return builder.toArray(new Integer[0]);
        }
        if (split[0].contains("N")) {
            return new Integer[]{-Integer.parseInt(split[0].replaceAll("\\D", ""))};
        }
        return new Integer[]{Integer.parseInt(split[0].replaceAll("\\D", ""))};
    }

    public static boolean registerNativeImageToIdentifier(NativeImage img, ResourceLocation identifier) {
        if (img != null && identifier != null) {
            DynamicTexture bob = new DynamicTexture(img);
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(identifier, (Texture)bob);
            KNOWN_NATIVE_IMAGES.put(identifier, img);
            return true;
        }
        ETFUtils2.logError("registering native image failed: " + img + ", " + identifier);
        return false;
    }

    public static void checkModCompatibility() {
        if (ETFVersionDifferenceHandler.isThisModLoaded("figura") && !ETFClientCommon.ETFConfigData.ignoredConfigs.contains((Object)ETFConfigScreenWarnings.ConfigWarning.FIGURA)) {
            ETFClientCommon.ETFConfigData.skinFeaturesEnabled = false;
            ETFUtils2.saveConfig();
        }
    }

    public static List<?> requireNonNullElse(List<?> object, List<?> object2) {
        return object == null ? object2 : object;
    }

    public static ResourceLocation requireNonNullElse(ResourceLocation object, ResourceLocation object2) {
        return object == null ? object2 : object;
    }

    public static ETFTexture requireNonNullElse(ETFTexture object, ETFTexture object2) {
        return object == null ? object2 : object;
    }
}

