/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_handlers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.config.screens.ETFConfigScreenSkinTool;
import traben.entity_texture_features.mixin.accessor.PlayerSkinProviderAccessor;
import traben.entity_texture_features.mixin.accessor.PlayerSkinTextureAccessor;
import traben.entity_texture_features.texture_handlers.ETFCustomPlayerFeatureModel;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFPlayerTexture {
    public static final String SKIN_NAMESPACE = "etf_skin";
    public static final UUID Dev = UUID.fromString("fd22e573-178c-415a-94fe-e476b328abfd");
    public static final UUID Wife = UUID.fromString("cab7d2e2-519f-4b34-afbd-b65f4542b8a1");
    private static final ResourceLocation villagerTexture = new ResourceLocation("textures/entity/villager/villager.png");
    public static NativeImage clientPlayerOriginalSkinImageForTool = null;
    public ResourceLocation baseEnchantIdentifier = null;
    public ResourceLocation baseEnchantBlinkIdentifier = null;
    public ResourceLocation baseEnchantBlink2Identifier = null;
    public ResourceLocation etfCapeIdentifier = null;
    public ResourceLocation texturedNoseIdentifier = null;
    public ResourceLocation texturedNoseIdentifierEmissive = null;
    public ResourceLocation texturedNoseIdentifierEnchanted = null;
    public boolean hasVillagerNose = false;
    public boolean hasFeatures = false;
    public int coatStyle = 0;
    public int coatLength = 1;
    public int blinkType = 0;
    public int blinkHeight = 1;
    public boolean hasEmissives = false;
    public boolean hasEnchant = false;
    public ETFTexture etfTextureOfFinalBaseSkin;
    public ETFConfigScreenSkinTool.CapeType capeType = ETFConfigScreenSkinTool.CapeType.NONE;
    public ETFConfigScreenSkinTool.NoseType noseType = ETFConfigScreenSkinTool.NoseType.NONE;
    PlayerEntity player;
    private ETFCustomPlayerFeatureModel<PlayerEntity> customPlayerModel;
    private boolean isTextureReady = false;
    private NativeImage originalSkin;
    private NativeImage originalCape;
    private boolean allowThisETFBaseSkin = true;
    private ResourceLocation coatIdentifier = null;
    private ResourceLocation coatEmissiveIdentifier = null;
    private ResourceLocation coatEnchantedIdentifier = null;
    private int[] enchantCapeBounds = null;
    private int[] emissiveCapeBounds = null;
    private ResourceLocation etfCapeEmissiveIdentifier = null;
    private ResourceLocation etfCapeEnchantedIdentifier = null;
    private ResourceLocation normalVanillaSkinIdentifier = null;
    private boolean hasFatCoat = false;

    ETFPlayerTexture(PlayerEntity player, ResourceLocation rendererGivenSkin) {
        this.player = player;
        this.normalVanillaSkinIdentifier = rendererGivenSkin;
        this.checkTexture(false);
    }

    private ETFPlayerTexture(ResourceLocation rendererGivenSkin) {
        this.player = null;
        this.normalVanillaSkinIdentifier = rendererGivenSkin;
    }

    public ETFPlayerTexture() {
        NativeImage skin;
        this.player = Minecraft.func_71410_x().field_71439_g;
        if (this.player != null && (skin = ETFUtils2.getNativeImageElseNull(Minecraft.func_71410_x().field_71439_g.func_110306_p())) != null) {
            clientPlayerOriginalSkinImageForTool = skin;
            this.changeSkinToThisForTool(skin);
            return;
        }
        ETFUtils2.logError("ETFPlayerTexture went wrong");
    }

    @Nullable
    private static NativeImage returnMatchPixels(NativeImage baseSkin, int[] boundsToCheck) {
        return ETFPlayerTexture.returnMatchPixels(baseSkin, boundsToCheck, null);
    }

    @Nullable
    private static NativeImage returnMatchPixels(NativeImage baseSkin, int[] boundsToCheck, @Nullable NativeImage second) {
        NativeImage texture;
        if (baseSkin == null || boundsToCheck == null) {
            return null;
        }
        boolean hasSecondImageToBeUsedAsBase = second != null;
        HashSet<Integer> matchColors = new HashSet<Integer>();
        for (int x = boundsToCheck[0]; x <= boundsToCheck[2]; ++x) {
            for (int y = boundsToCheck[1]; y <= boundsToCheck[3]; ++y) {
                if (baseSkin.func_211675_e(x, y) == 0) continue;
                matchColors.add(baseSkin.func_195709_a(x, y));
            }
        }
        if (matchColors.isEmpty()) {
            return null;
        }
        if (!hasSecondImageToBeUsedAsBase) {
            texture = new NativeImage(baseSkin.func_195702_a(), baseSkin.func_195714_b(), false);
            texture.func_195703_a(baseSkin);
        } else {
            texture = new NativeImage(second.func_195702_a(), second.func_195714_b(), false);
            texture.func_195703_a(second);
        }
        for (int x = 0; x < texture.func_195702_a(); ++x) {
            for (int y = 0; y < texture.func_195714_b(); ++y) {
                if (matchColors.contains(texture.func_195709_a(x, y))) continue;
                texture.func_195700_a(x, y, 0);
            }
        }
        return ETFPlayerTexture.returnNullIfEmptyImage(texture);
    }

    @Nullable
    private static NativeImage returnNullIfEmptyImage(NativeImage imageToCheck) {
        boolean foundAPixel = false;
        block0: for (int x = 0; x < imageToCheck.func_195702_a(); ++x) {
            for (int y = 0; y < imageToCheck.func_195714_b(); ++y) {
                if (imageToCheck.func_195709_a(x, y) == 0) continue;
                foundAPixel = true;
                break block0;
            }
        }
        return foundAPixel ? imageToCheck : null;
    }

    private static NativeImage returnCustomTexturedCape(NativeImage skin) {
        NativeImage cape = ETFUtils2.emptyNativeImage(64, 32);
        NativeImage elytra = ETFUtils2.getNativeImageElseNull(new ResourceLocation("textures/entity/elytra.png"));
        if (elytra == null || elytra.func_195702_a() != 64 || elytra.func_195714_b() != 32) {
            elytra = ETFUtils2.getNativeImageElseNull(new ResourceLocation("entity_texture_features", "textures/capes/default_elytra.png"));
        }
        if (elytra != null) {
            cape.func_195703_a(elytra);
        }
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape1"), 1, 1);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape1"), 12, 1);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape2"), 1, 5);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape2"), 12, 5);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape3"), 1, 9);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape3"), 12, 9);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape4"), 1, 13);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape4"), 12, 13);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.1"), 9, 1);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.1"), 20, 1);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.2"), 9, 5);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.2"), 20, 5);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.3"), 9, 9);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.3"), 20, 9);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.4"), 9, 13);
        ETFPlayerTexture.copyToPixels(skin, cape, ETFPlayerTexture.getSkinPixelBounds("cape5.4"), 20, 13);
        ETFPlayerTexture.copyToPixels(cape, cape, ETFPlayerTexture.getSkinPixelBounds("capeVertL"), 0, 1);
        ETFPlayerTexture.copyToPixels(cape, cape, ETFPlayerTexture.getSkinPixelBounds("capeVertR"), 11, 1);
        ETFPlayerTexture.copyToPixels(cape, cape, ETFPlayerTexture.getSkinPixelBounds("capeHorizL"), 1, 0);
        ETFPlayerTexture.copyToPixels(cape, cape, ETFPlayerTexture.getSkinPixelBounds("capeHorizR"), 11, 0);
        return cape;
    }

    private static int[] getSkinPixelBounds(String choiceKey) {
        switch (choiceKey) {
            case "marker1": {
                return new int[]{56, 16, 63, 23};
            }
            case "marker2": {
                return new int[]{56, 24, 63, 31};
            }
            case "marker3": {
                return new int[]{56, 32, 63, 39};
            }
            case "marker4": {
                return new int[]{56, 40, 63, 47};
            }
            case "optimizedEyeSmall": {
                return new int[]{12, 16, 19, 16};
            }
            case "optimizedEye2High": {
                return new int[]{12, 16, 19, 17};
            }
            case "optimizedEye2High_second": {
                return new int[]{12, 18, 19, 19};
            }
            case "optimizedEye4High": {
                return new int[]{12, 16, 19, 19};
            }
            case "optimizedEye4High_second": {
                return new int[]{36, 16, 43, 19};
            }
            case "face1": {
                return new int[]{0, 0, 7, 7};
            }
            case "face2": {
                return new int[]{24, 0, 31, 7};
            }
            case "face3": {
                return new int[]{32, 0, 39, 7};
            }
            case "face4": {
                return new int[]{56, 0, 63, 7};
            }
            case "cape1": {
                return new int[]{12, 32, 19, 35};
            }
            case "cape2": {
                return new int[]{36, 32, 43, 35};
            }
            case "cape3": {
                return new int[]{12, 48, 19, 51};
            }
            case "cape4": {
                return new int[]{28, 48, 35, 51};
            }
            case "cape5": {
                return new int[]{44, 48, 51, 51};
            }
            case "cape5.1": {
                return new int[]{44, 48, 45, 51};
            }
            case "cape5.2": {
                return new int[]{46, 48, 47, 51};
            }
            case "cape5.3": {
                return new int[]{48, 48, 49, 51};
            }
            case "cape5.4": {
                return new int[]{50, 48, 51, 51};
            }
            case "capeVertL": {
                return new int[]{1, 1, 1, 16};
            }
            case "capeVertR": {
                return new int[]{10, 1, 10, 16};
            }
            case "capeHorizL": {
                return new int[]{1, 1, 10, 1};
            }
            case "capeHorizR": {
                return new int[]{1, 16, 10, 16};
            }
        }
        return new int[]{0, 0, 0, 0};
    }

    private static NativeImage returnOptimizedBlinkFace(NativeImage baseSkin, int[] eyeBounds, int eyeHeightFromTopDown) {
        return ETFPlayerTexture.returnOptimizedBlinkFace(baseSkin, eyeBounds, eyeHeightFromTopDown, null);
    }

    private static NativeImage returnOptimizedBlinkFace(NativeImage baseSkin, int[] eyeBounds, int eyeHeightFromTopDown, int[] secondLayerBounds) {
        NativeImage texture = new NativeImage(64, 64, false);
        texture.func_195703_a(baseSkin);
        ETFPlayerTexture.copyToPixels(baseSkin, texture, eyeBounds, 8, 8 + (eyeHeightFromTopDown - 1));
        if (secondLayerBounds != null) {
            ETFPlayerTexture.copyToPixels(baseSkin, texture, secondLayerBounds, 40, 8 + (eyeHeightFromTopDown - 1));
        }
        return texture;
    }

    private static int countTransparentInBox(NativeImage img, int x1, int y1, int x2, int y2) {
        int counter = 0;
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                int i = img.func_211675_e(x, y);
                if (i < 0) {
                    i += 256;
                }
                counter += i;
            }
        }
        return counter;
    }

    private static boolean isSkinNotTooTransparent(NativeImage skin) {
        if (ETFClientCommon.ETFConfigData.skinFeaturesEnableFullTransparency) {
            return true;
        }
        int countTransparent = 0;
        countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 8, 0, 23, 15);
        countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 0, 20, 55, 31);
        countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 0, 8, 7, 15);
        countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 24, 8, 31, 15);
        countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 0, 16, 11, 19);
        countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 20, 16, 35, 19);
        countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 44, 16, 51, 19);
        countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 20, 48, 27, 51);
        countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 36, 48, 43, 51);
        int average = (countTransparent += ETFPlayerTexture.countTransparentInBox(skin, 16, 52, 47, 63)) / 1648;
        return average >= 100;
    }

    private static NativeImage getCoatTexture(NativeImage skin, int lengthOfCoat, boolean ignoreTopTexture) {
        NativeImage coat = new NativeImage(64, 64, false);
        coat.func_195715_a(0, 0, 64, 64, 0);
        if (!ignoreTopTexture) {
            ETFPlayerTexture.copyToPixels(skin, coat, 4, 32, 7, 35 + lengthOfCoat, 20, 32);
            ETFPlayerTexture.copyToPixels(skin, coat, 4, 48, 7, 51 + lengthOfCoat, 24, 32);
        }
        ETFPlayerTexture.copyToPixels(skin, coat, 0, 36, 7, 36 + lengthOfCoat, 16, 36);
        ETFPlayerTexture.copyToPixels(skin, coat, 12, 36, 15, 36 + lengthOfCoat, 36, 36);
        ETFPlayerTexture.copyToPixels(skin, coat, 4, 52, 15, 52 + lengthOfCoat, 24, 36);
        return coat;
    }

    private static void copyToPixels(NativeImage source, NativeImage dest, int[] bounds, int copyToX, int CopyToY) {
        ETFPlayerTexture.copyToPixels(source, dest, bounds[0], bounds[1], bounds[2], bounds[3], copyToX, CopyToY);
    }

    private static void copyToPixels(NativeImage source, NativeImage dest, int x1, int y1, int x2, int y2, int copyToX, int copyToY) {
        int copyToXRelative = copyToX - x1;
        int copyToYRelative = copyToY - y1;
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                dest.func_195700_a(x + copyToXRelative, y + copyToYRelative, source.func_195709_a(x, y));
            }
        }
    }

    private static void deletePixels(NativeImage source, int x1, int y1, int x2, int y2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                source.func_195700_a(x, y, 0);
            }
        }
    }

    private static int getSkinPixelColourToNumber(int color) {
        switch (color) {
            case -65281: {
                return 1;
            }
            case -256: {
                return 2;
            }
            case -16776961: {
                return 3;
            }
            case -16711936: {
                return 4;
            }
            case -16760705: {
                return 5;
            }
            case -65536: {
                return 6;
            }
            case -16744449: {
                return 7;
            }
            case -14483457: {
                return 8;
            }
            case -12362096: {
                return 666;
            }
        }
        return 0;
    }

    public boolean isCorrectObjectForThisSkin(ResourceLocation check) {
        return check.equals((Object)this.normalVanillaSkinIdentifier);
    }

    public boolean hasCustomCape() {
        return this.etfCapeIdentifier != null;
    }

    @Nullable
    public ResourceLocation getBaseTextureIdentifierOrNullForVanilla(PlayerEntity player) {
        this.player = player;
        if (this.allowThisETFBaseSkin && this.canUseFeaturesForThisPlayer() && this.etfTextureOfFinalBaseSkin != null) {
            return this.etfTextureOfFinalBaseSkin.getTextureIdentifier((Entity)player);
        }
        return null;
    }

    @Nullable
    public ResourceLocation getBaseTextureEmissiveIdentifierOrNullForNone() {
        if (this.hasEmissives && this.canUseFeaturesForThisPlayer() && this.etfTextureOfFinalBaseSkin != null) {
            return this.etfTextureOfFinalBaseSkin.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    @Nullable
    public ResourceLocation getBaseTextureEnchantIdentifierOrNullForNone() {
        if (this.hasEnchant && this.canUseFeaturesForThisPlayer() && this.etfTextureOfFinalBaseSkin != null) {
            switch (this.etfTextureOfFinalBaseSkin.currentTextureState) {
                case NORMAL: {
                    return this.baseEnchantIdentifier;
                }
                case NORMAL_PATCHED: {
                    return this.baseEnchantIdentifier;
                }
                case BLINK: {
                    return this.baseEnchantBlinkIdentifier;
                }
                case BLINK_PATCHED: {
                    return this.baseEnchantBlinkIdentifier;
                }
                case BLINK2: {
                    return this.baseEnchantBlink2Identifier;
                }
                case BLINK2_PATCHED: {
                    return this.baseEnchantBlink2Identifier;
                }
            }
            return null;
        }
        return null;
    }

    public void renderCapeAndFeatures(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int light, PlayerModel<AbstractClientPlayerEntity> model) {
        if (this.canUseFeaturesForThisPlayer() && this.etfCapeIdentifier != null) {
            IVertexBuilder vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.etfCapeIdentifier));
            model.func_228289_b_(matrixStack, vertexConsumer, light, OverlayTexture.field_229196_a_);
            if (this.etfCapeEmissiveIdentifier != null) {
                IVertexBuilder emissiveVert = vertexConsumerProvider.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.etfCapeEmissiveIdentifier));
                model.func_228289_b_(matrixStack, emissiveVert, 0xF000F0, OverlayTexture.field_229196_a_);
            }
            if (this.etfCapeEnchantedIdentifier != null) {
                IVertexBuilder enchantVert = ItemRenderer.func_239386_a_((IRenderTypeBuffer)vertexConsumerProvider, (RenderType)RenderType.func_239263_a_((ResourceLocation)this.etfCapeEnchantedIdentifier), (boolean)false, (boolean)true);
                model.func_228289_b_(matrixStack, enchantVert, light, OverlayTexture.field_229196_a_);
            }
        }
    }

    public boolean canUseFeaturesForThisPlayer() {
        return this.isTextureReady && this.hasFeatures && (ETFClientCommon.ETFConfigData.enableEnemyTeamPlayersSkinFeatures || this.player.func_184191_r((Entity)Minecraft.func_71410_x().field_71439_g) || this.player.func_96124_cp() == null);
    }

    public void renderFeatures(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int light, PlayerModel<PlayerEntity> model) {
        if (this.canUseFeaturesForThisPlayer()) {
            IVertexBuilder enchantVert;
            if (this.hasVillagerNose) {
                this.customPlayerModel.villagerNose.func_217177_a(model.field_78116_c);
                IVertexBuilder villagerVert = vertexConsumerProvider.getBuffer(RenderType.func_228634_a_((ResourceLocation)villagerTexture));
                this.customPlayerModel.villagerNose.func_228309_a_(matrixStack, villagerVert, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else if (this.texturedNoseIdentifier != null) {
                this.customPlayerModel.textureNose.func_217177_a(model.field_78116_c);
                IVertexBuilder noseVertex = vertexConsumerProvider.getBuffer(RenderType.func_228642_d_((ResourceLocation)this.texturedNoseIdentifier));
                this.customPlayerModel.textureNose.func_228309_a_(matrixStack, noseVertex, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                if (this.texturedNoseIdentifierEmissive != null) {
                    this.customPlayerModel.textureNose.func_217177_a(model.field_78116_c);
                    IVertexBuilder noseVertex_e = ETFManager.getEmissiveMode() == ETFManager.EmissiveRenderModes.BRIGHT ? vertexConsumerProvider.getBuffer(RenderType.func_228637_a_((ResourceLocation)this.texturedNoseIdentifierEmissive, (boolean)true)) : vertexConsumerProvider.getBuffer(RenderType.func_228642_d_((ResourceLocation)this.texturedNoseIdentifierEmissive));
                    this.customPlayerModel.textureNose.func_228309_a_(matrixStack, noseVertex_e, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (this.texturedNoseIdentifierEnchanted != null) {
                    this.customPlayerModel.textureNose.func_217177_a(model.field_78116_c);
                    IVertexBuilder noseVertex_ench = ItemRenderer.func_239386_a_((IRenderTypeBuffer)vertexConsumerProvider, (RenderType)RenderType.func_239263_a_((ResourceLocation)this.texturedNoseIdentifierEnchanted), (boolean)false, (boolean)true);
                    this.customPlayerModel.textureNose.func_228309_a_(matrixStack, noseVertex_ench, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            ItemStack armour = this.player.field_71071_by.func_70440_f(1);
            if (this.coatIdentifier != null && this.player.func_175148_a(PlayerModelPart.JACKET) && armour.func_77973_b() != Items.field_151022_W && armour.func_77973_b() != Items.field_151026_S && armour.func_77973_b() != Items.field_151173_ae && armour.func_77973_b() != Items.field_151149_ai && armour.func_77973_b() != Items.field_151165_aa && armour.func_77973_b() != Items.field_234765_lu_) {
                if (this.hasFatCoat) {
                    this.customPlayerModel.fatJacket.func_217177_a(model.field_178730_v);
                } else {
                    this.customPlayerModel.jacket.func_217177_a(model.field_178730_v);
                }
                IVertexBuilder coatVert = vertexConsumerProvider.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.coatIdentifier));
                matrixStack.func_227860_a_();
                if (this.hasFatCoat) {
                    this.customPlayerModel.fatJacket.func_228309_a_(matrixStack, coatVert, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                } else {
                    this.customPlayerModel.jacket.func_228309_a_(matrixStack, coatVert, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (this.coatEnchantedIdentifier != null) {
                    enchantVert = ItemRenderer.func_239386_a_((IRenderTypeBuffer)vertexConsumerProvider, (RenderType)RenderType.func_239263_a_((ResourceLocation)this.coatEnchantedIdentifier), (boolean)false, (boolean)true);
                    if (this.hasFatCoat) {
                        this.customPlayerModel.fatJacket.func_228309_a_(matrixStack, enchantVert, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 0.16f);
                    } else {
                        this.customPlayerModel.jacket.func_228309_a_(matrixStack, enchantVert, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 0.16f);
                    }
                }
                if (this.coatEmissiveIdentifier != null) {
                    IVertexBuilder emissiveVert = ETFManager.getEmissiveMode() == ETFManager.EmissiveRenderModes.BRIGHT ? vertexConsumerProvider.getBuffer(RenderType.func_228637_a_((ResourceLocation)this.coatEmissiveIdentifier, (boolean)true)) : vertexConsumerProvider.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.coatEmissiveIdentifier));
                    if (this.hasFatCoat) {
                        this.customPlayerModel.fatJacket.func_228309_a_(matrixStack, emissiveVert, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                    } else {
                        this.customPlayerModel.jacket.func_228309_a_(matrixStack, emissiveVert, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
                matrixStack.func_227865_b_();
            }
            if (this.hasEmissives && this.etfTextureOfFinalBaseSkin != null) {
                this.etfTextureOfFinalBaseSkin.renderEmissive(matrixStack, vertexConsumerProvider, (Model)model);
            }
            if (this.hasEnchant && this.baseEnchantIdentifier != null && this.etfTextureOfFinalBaseSkin != null) {
                ResourceLocation identifierFromSwitch;
                switch (this.etfTextureOfFinalBaseSkin.currentTextureState) {
                    case BLINK: 
                    case BLINK_PATCHED: 
                    case APPLY_BLINK: {
                        identifierFromSwitch = this.baseEnchantBlinkIdentifier;
                        break;
                    }
                    case BLINK2: 
                    case BLINK2_PATCHED: 
                    case APPLY_BLINK2: {
                        identifierFromSwitch = this.baseEnchantBlink2Identifier;
                        break;
                    }
                    default: {
                        identifierFromSwitch = this.baseEnchantIdentifier;
                    }
                }
                enchantVert = ItemRenderer.func_239386_a_((IRenderTypeBuffer)vertexConsumerProvider, (RenderType)RenderType.func_239263_a_((ResourceLocation)identifierFromSwitch), (boolean)false, (boolean)true);
                model.func_225598_a_(matrixStack, enchantVert, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 0.16f);
            }
        }
    }

    private void initiateThirdPartyCapeDownload(String capeUrl) {
        CompletableFuture.runAsync(() -> {
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(capeUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(false);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() / 100 == 2) {
                    InputStream inputStream = httpURLConnection.getInputStream();
                    Minecraft.func_71410_x().execute(() -> {
                        try {
                            NativeImage one = NativeImage.func_195713_a((InputStream)inputStream);
                            this.receiveThirdPartyCape(one);
                        }
                        catch (Exception e) {
                            ETFUtils2.logError("ThirdPartyCapeDownload failed for player:" + this.player.func_200200_C_().getString() + "retrying again later " + e);
                            e.printStackTrace();
                        }
                    });
                }
            }
            catch (Exception var6) {
                ETFUtils2.logError("ThirdPartyCapeDownload2 failed for player:" + this.player.func_200200_C_().getString() + "retrying again later" + var6);
            }
        }, Util.func_215072_e());
    }

    public void receiveThirdPartyCape(@NotNull NativeImage capeImage) {
        ResourceLocation newCapeId = new ResourceLocation(SKIN_NAMESPACE, this.player.func_110124_au().toString().replaceAll("/[^a-z]/g", "") + "_cape_third_party.png");
        if (capeImage.func_195702_a() % capeImage.func_195714_b() != 0) {
            int newWidth;
            for (newWidth = 64; newWidth < capeImage.func_195702_a(); newWidth += newWidth) {
            }
            int newHeight = newWidth / 2;
            try {
                NativeImage resizedImage = ETFUtils2.emptyNativeImage(newWidth, newHeight);
                for (int x = 0; x < capeImage.func_195702_a(); ++x) {
                    for (int y = 0; y < capeImage.func_195714_b(); ++y) {
                        resizedImage.func_195700_a(x, y, capeImage.func_195709_a(x, y));
                    }
                }
                this.checkThirdPartyCapeFeaturesAndFinalize(resizedImage, newCapeId);
            }
            catch (Exception e) {
                ETFUtils2.logError("optifine cape resize failed");
            }
        } else {
            this.checkThirdPartyCapeFeaturesAndFinalize(capeImage, newCapeId);
        }
    }

    private void checkThirdPartyCapeFeaturesAndFinalize(NativeImage capeImage, ResourceLocation newCapeId) {
        NativeImage checkCapeEmissive = ETFPlayerTexture.returnMatchPixels(this.originalSkin, this.emissiveCapeBounds, capeImage);
        if (checkCapeEmissive != null) {
            ResourceLocation newCapeEmissive = new ResourceLocation(SKIN_NAMESPACE, this.player.func_110124_au() + "_cape_third_party_e.png");
            ETFUtils2.registerNativeImageToIdentifier(checkCapeEmissive, newCapeEmissive);
            this.etfCapeEmissiveIdentifier = newCapeEmissive;
        } else {
            this.etfCapeEmissiveIdentifier = null;
        }
        NativeImage checkCapeEnchant = ETFPlayerTexture.returnMatchPixels(this.originalSkin, this.enchantCapeBounds, capeImage);
        if (checkCapeEnchant != null) {
            ResourceLocation newCapeEnchanted = new ResourceLocation(SKIN_NAMESPACE, this.player.func_110124_au() + "_cape_third_party_enchant.png");
            ETFUtils2.registerNativeImageToIdentifier(checkCapeEnchant, newCapeEnchanted);
            this.etfCapeEnchantedIdentifier = newCapeEnchanted;
        } else {
            this.etfCapeEnchantedIdentifier = null;
        }
        ETFUtils2.registerNativeImageToIdentifier(capeImage, newCapeId);
        this.etfCapeIdentifier = newCapeId;
    }

    private void skinFailed() {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof ETFConfigScreenSkinTool)) {
            ETFManager.getInstance().PLAYER_TEXTURE_MAP.put(this.player.func_110124_au(), new ETFPlayerTexture(this.normalVanillaSkinIdentifier));
        } else {
            ETFUtils2.logError("something went wrong applying skin in tool, or skin features are not added");
        }
    }

    public void checkTexture(boolean skipSkinLoad) {
        NativeImage modifiedCape;
        if (!skipSkinLoad) {
            try {
                DownloadingTexture skin = (DownloadingTexture)((PlayerSkinProviderAccessor)Minecraft.func_71410_x().func_152342_ad()).getTextureManager().func_229267_b_(this.normalVanillaSkinIdentifier);
                FileInputStream fileInputStream = new FileInputStream(((PlayerSkinTextureAccessor)skin).getCacheFile());
                NativeImage vanilla = NativeImage.func_195713_a((InputStream)fileInputStream);
                fileInputStream.close();
                this.originalSkin = ETFUtils2.emptyNativeImage(64, 64);
                this.originalSkin.func_195703_a(vanilla);
                if (Minecraft.func_71410_x().field_71439_g != null && this.player.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                    clientPlayerOriginalSkinImageForTool = this.originalSkin;
                }
                vanilla.close();
                try {
                    ResourceLocation capeId = ((AbstractClientPlayerEntity)this.player).func_110303_q();
                    DownloadingTexture cape = (DownloadingTexture)((PlayerSkinProviderAccessor)Minecraft.func_71410_x().func_152342_ad()).getTextureManager().func_229267_b_(capeId);
                    if (cape != null) {
                        FileInputStream fileInputStreamCape = new FileInputStream(((PlayerSkinTextureAccessor)cape).getCacheFile());
                        NativeImage vanillaCape = NativeImage.func_195713_a((InputStream)fileInputStreamCape);
                        fileInputStreamCape.close();
                        this.originalCape = ETFUtils2.emptyNativeImage(64, 32);
                        this.originalCape.func_195703_a(vanillaCape);
                        vanillaCape.close();
                    }
                }
                catch (Exception capeId) {}
            }
            catch (Exception e) {
                this.skinFailed();
                return;
            }
        }
        UUID id = this.player.func_110124_au();
        if (this.originalCape != null) {
            modifiedCape = ETFUtils2.emptyNativeImage(this.originalCape.func_195702_a(), this.originalCape.func_195714_b());
            modifiedCape.func_195703_a(this.originalCape);
        } else {
            modifiedCape = ETFUtils2.emptyNativeImage(64, 32);
        }
        NativeImage modifiedSkin = ETFUtils2.emptyNativeImage(this.originalSkin.func_195702_a(), this.originalSkin.func_195714_b());
        modifiedSkin.func_195703_a(this.originalSkin);
        if (this.originalSkin != null) {
            if (this.originalSkin.func_195709_a(1, 16) == -16776961 && this.originalSkin.func_195709_a(0, 16) == -16777089 && this.originalSkin.func_195709_a(0, 17) == -16776961 && this.originalSkin.func_195709_a(2, 16) == -16711936 && this.originalSkin.func_195709_a(3, 16) == -16744704 && this.originalSkin.func_195709_a(3, 17) == -16711936 && this.originalSkin.func_195709_a(0, 18) == -65536 && this.originalSkin.func_195709_a(0, 19) == -8454144 && this.originalSkin.func_195709_a(1, 19) == -65536 && this.originalSkin.func_195709_a(3, 18) == -1 && this.originalSkin.func_195709_a(2, 19) == -1 && this.originalSkin.func_195709_a(3, 18) == -1) {
                int[] boxChosenBounds;
                int capeChoice1;
                int blinkChoice;
                this.customPlayerModel = new ETFCustomPlayerFeatureModel();
                this.hasFeatures = true;
                ETFUtils2.logMessage("Found Player {" + this.player.func_200200_C_().getString() + "} with texture features in skin.", false);
                int[] choiceBoxChoices = new int[]{ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(52, 16)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(52, 17)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(52, 18)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(52, 19)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(53, 16)), ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(53, 17))};
                boolean noseUpper = ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(43, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(44, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(43, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(44, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(43, 15)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(44, 15)) == 666;
                boolean noseLower = ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(11, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(12, 13)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(11, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(12, 14)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(11, 15)) == 666 && ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(12, 15)) == 666;
                boolean bl = this.hasVillagerNose = noseLower || noseUpper;
                if (noseUpper) {
                    ETFPlayerTexture.deletePixels(modifiedSkin, 43, 13, 44, 15);
                }
                NativeImage noseTexture = null;
                int noseChoice = choiceBoxChoices[5];
                if (noseChoice >= 1 && noseChoice <= 6) {
                    if (noseChoice == 1) {
                        this.hasVillagerNose = true;
                        this.noseType = ETFConfigScreenSkinTool.NoseType.VILLAGER;
                    } else {
                        int y;
                        int x;
                        int[] bounds;
                        noseTexture = ETFUtils2.emptyNativeImage(8, 8);
                        switch (noseChoice) {
                            case 3: {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_2;
                                bounds = ETFPlayerTexture.getSkinPixelBounds("cape2");
                                break;
                            }
                            case 4: {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_3;
                                bounds = ETFPlayerTexture.getSkinPixelBounds("cape3");
                                break;
                            }
                            case 5: {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_4;
                                bounds = ETFPlayerTexture.getSkinPixelBounds("cape4");
                                break;
                            }
                            case 6: {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_5;
                                bounds = ETFPlayerTexture.getSkinPixelBounds("cape5");
                                break;
                            }
                            default: {
                                this.noseType = ETFConfigScreenSkinTool.NoseType.TEXTURED_1;
                                bounds = ETFPlayerTexture.getSkinPixelBounds("cape1");
                            }
                        }
                        int noseY = 0;
                        for (x = bounds[0]; x <= bounds[2]; ++x) {
                            int noseX = 0;
                            for (int y2 = bounds[1]; y2 <= bounds[3]; ++y2) {
                                noseTexture.func_195700_a(noseX, noseY, this.originalSkin.func_195709_a(x, y2));
                                ++noseX;
                            }
                            ++noseY;
                        }
                        for (x = 4; x < 8; ++x) {
                            for (y = 0; y < 8; ++y) {
                                noseTexture.func_195700_a(x, y, noseTexture.func_195709_a(7 - x, y));
                            }
                        }
                        for (x = 0; x < 8; ++x) {
                            for (y = 0; y < 4; ++y) {
                                int lowerColour = noseTexture.func_195709_a(x, y + 4);
                                noseTexture.func_195700_a(x, y + 4, noseTexture.func_195709_a(x, y));
                                noseTexture.func_195700_a(x, y, lowerColour);
                            }
                        }
                        this.texturedNoseIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_nose.png");
                        ETFUtils2.registerNativeImageToIdentifier(noseTexture, this.texturedNoseIdentifier);
                    }
                }
                NativeImage coatSkin = null;
                int controllerCoat = choiceBoxChoices[1];
                if (controllerCoat >= 1 && controllerCoat <= 8) {
                    this.coatStyle = controllerCoat;
                    int lengthOfCoat = choiceBoxChoices[2] - 1;
                    this.coatLength = lengthOfCoat + 1;
                    this.coatIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_coat.png");
                    coatSkin = ETFPlayerTexture.getCoatTexture(this.originalSkin, lengthOfCoat, controllerCoat >= 5);
                    ETFUtils2.registerNativeImageToIdentifier(coatSkin, this.coatIdentifier);
                    if (controllerCoat == 2 || controllerCoat == 4 || controllerCoat == 6 || controllerCoat == 8) {
                        ETFPlayerTexture.deletePixels(modifiedSkin, 4, 32, 7, 35);
                        ETFPlayerTexture.deletePixels(modifiedSkin, 4, 48, 7, 51);
                        ETFPlayerTexture.deletePixels(modifiedSkin, 0, 36, 15, 36 + lengthOfCoat);
                        ETFPlayerTexture.deletePixels(modifiedSkin, 0, 52, 15, 52 + lengthOfCoat);
                    }
                    this.hasFatCoat = controllerCoat == 3 || controllerCoat == 4 || controllerCoat == 7 || controllerCoat == 8;
                } else {
                    this.coatIdentifier = null;
                }
                if (ETFClientCommon.ETFConfigData.skinFeaturesEnableTransparency) {
                    if (ETFPlayerTexture.isSkinNotTooTransparent(this.originalSkin)) {
                        this.allowThisETFBaseSkin = true;
                    } else {
                        ETFUtils2.logMessage("Skin was too transparent or had other problems", false);
                        this.allowThisETFBaseSkin = false;
                    }
                }
                NativeImage blinkSkinFile = null;
                NativeImage blinkSkinFile2 = null;
                ResourceLocation blinkIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_blink.png");
                ResourceLocation blink2Identifier = new ResourceLocation(SKIN_NAMESPACE, id + "_blink2.png");
                this.blinkType = blinkChoice = choiceBoxChoices[0];
                if (blinkChoice >= 1 && blinkChoice <= 5) {
                    if (blinkChoice <= 2) {
                        blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("face1"), 1, ETFPlayerTexture.getSkinPixelBounds("face3"));
                        ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                        if (blinkChoice == 2) {
                            blinkSkinFile2 = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("face2"), 1, ETFPlayerTexture.getSkinPixelBounds("face4"));
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, blink2Identifier);
                        }
                    } else {
                        int eyeHeightTopDown;
                        this.blinkHeight = eyeHeightTopDown = choiceBoxChoices[3];
                        if (eyeHeightTopDown > 8 || eyeHeightTopDown < 1) {
                            eyeHeightTopDown = 1;
                        }
                        if (blinkChoice == 3) {
                            blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEyeSmall"), eyeHeightTopDown);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                        } else if (blinkChoice == 4) {
                            blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye2High"), eyeHeightTopDown);
                            blinkSkinFile2 = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye2High_second"), eyeHeightTopDown);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, blink2Identifier);
                        } else {
                            blinkSkinFile = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye4High"), eyeHeightTopDown);
                            blinkSkinFile2 = ETFPlayerTexture.returnOptimizedBlinkFace(modifiedSkin, ETFPlayerTexture.getSkinPixelBounds("optimizedEye4High_second"), eyeHeightTopDown);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, blinkIdentifier);
                            ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, blink2Identifier);
                        }
                    }
                }
                if (blinkSkinFile == null) {
                    blinkIdentifier = null;
                }
                if (blinkSkinFile2 == null) {
                    blink2Identifier = null;
                }
                if ((capeChoice1 = choiceBoxChoices[4]) >= 1 && capeChoice1 <= 4) {
                    switch (capeChoice1) {
                        case 1: {
                            this.capeType = ETFConfigScreenSkinTool.CapeType.CUSTOM;
                            modifiedCape.func_195703_a(ETFPlayerTexture.returnCustomTexturedCape(this.originalSkin));
                            break;
                        }
                        case 2: {
                            modifiedCape = null;
                            this.capeType = ETFConfigScreenSkinTool.CapeType.MINECRAFT_CAPES_NET;
                            this.initiateThirdPartyCapeDownload("https://minecraftcapes.net/profile/" + this.player.func_189512_bd().replace("-", "") + "/cape/");
                            break;
                        }
                        case 3: {
                            modifiedCape = null;
                            this.capeType = ETFConfigScreenSkinTool.CapeType.OPTIFINE;
                            this.initiateThirdPartyCapeDownload("https://optifine.net/capes/" + this.player.func_200200_C_().getString() + ".png");
                            break;
                        }
                        case 4: {
                            this.capeType = ETFConfigScreenSkinTool.CapeType.ETF;
                            NativeImage cape = ETFUtils2.getNativeImageElseNull(new ResourceLocation("entity_texture_features", "textures/capes/etf.png"));
                            if (cape == null || ETFUtils2.isNativeImageEmpty(modifiedCape)) break;
                            modifiedCape.func_195703_a(cape);
                            break;
                        }
                    }
                }
                if (modifiedCape != null && !ETFUtils2.isNativeImageEmpty(modifiedCape)) {
                    this.etfCapeIdentifier = new ResourceLocation(SKIN_NAMESPACE, id.toString().replaceAll("/[^a-z]/g", "") + "_cape.png");
                    ETFUtils2.registerNativeImageToIdentifier(modifiedCape, this.etfCapeIdentifier);
                }
                ArrayList<Integer> markerChoices = new ArrayList<Integer>();
                markerChoices.add(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(1, 17)));
                markerChoices.add(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(1, 18)));
                markerChoices.add(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(2, 17)));
                markerChoices.add(ETFPlayerTexture.getSkinPixelColourToNumber(this.originalSkin.func_195709_a(2, 18)));
                NativeImage emissiveImage = null;
                NativeImage emissiveBlinkImage = null;
                NativeImage emissiveBlink2Image = null;
                ResourceLocation emissiveIdentifier = null;
                ResourceLocation blinkEmissiveIdentifier = null;
                ResourceLocation blink2EmissiveIdentifier = null;
                this.hasEmissives = markerChoices.contains(1);
                if (this.hasEmissives) {
                    boxChosenBounds = ETFPlayerTexture.getSkinPixelBounds("marker" + (markerChoices.indexOf(1) + 1));
                    this.emissiveCapeBounds = boxChosenBounds;
                    emissiveImage = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds);
                    if (emissiveImage != null) {
                        NativeImage checkNose;
                        NativeImage checkCape;
                        NativeImage checkCoat;
                        emissiveIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_e.png");
                        ETFUtils2.registerNativeImageToIdentifier(emissiveImage, emissiveIdentifier);
                        if (blinkSkinFile != null && (emissiveBlinkImage = ETFPlayerTexture.returnMatchPixels(blinkSkinFile, boxChosenBounds)) != null) {
                            blinkEmissiveIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_blink_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(emissiveBlinkImage, blinkEmissiveIdentifier);
                        }
                        if (blinkSkinFile2 != null && (emissiveBlink2Image = ETFPlayerTexture.returnMatchPixels(blinkSkinFile2, boxChosenBounds)) != null) {
                            blink2EmissiveIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_blink2_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(emissiveBlink2Image, blink2EmissiveIdentifier);
                        }
                        if (coatSkin != null && (checkCoat = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, coatSkin)) != null) {
                            this.coatEmissiveIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_coat_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCoat, this.coatEmissiveIdentifier);
                        }
                        if (modifiedCape != null && (checkCape = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, modifiedCape)) != null) {
                            this.etfCapeEmissiveIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_cape_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCape, this.etfCapeEmissiveIdentifier);
                        }
                        if (noseTexture != null && (checkNose = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, noseTexture)) != null) {
                            this.texturedNoseIdentifierEmissive = new ResourceLocation(SKIN_NAMESPACE, id + "_nose_e.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkNose, this.texturedNoseIdentifierEmissive);
                        }
                    } else {
                        this.hasEmissives = false;
                    }
                }
                this.hasEnchant = markerChoices.contains(2);
                if (this.hasEnchant) {
                    boxChosenBounds = ETFPlayerTexture.getSkinPixelBounds("marker" + (markerChoices.indexOf(2) + 1));
                    this.enchantCapeBounds = boxChosenBounds;
                    NativeImage check = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds);
                    if (check != null) {
                        NativeImage checkNose;
                        NativeImage checkCape;
                        NativeImage checkCoat;
                        NativeImage checkBlink;
                        this.baseEnchantIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_enchant.png");
                        ETFUtils2.registerNativeImageToIdentifier(check, this.baseEnchantIdentifier);
                        if (blinkSkinFile != null && (checkBlink = ETFPlayerTexture.returnMatchPixels(blinkSkinFile, boxChosenBounds)) != null) {
                            this.baseEnchantBlinkIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_blink_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkBlink, this.baseEnchantBlinkIdentifier);
                        }
                        if (blinkSkinFile2 != null && (checkBlink = ETFPlayerTexture.returnMatchPixels(blinkSkinFile2, boxChosenBounds)) != null) {
                            this.baseEnchantBlink2Identifier = new ResourceLocation(SKIN_NAMESPACE, id + "_blink2_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkBlink, this.baseEnchantBlink2Identifier);
                        }
                        if (coatSkin != null && (checkCoat = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, coatSkin)) != null) {
                            this.coatEnchantedIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_coat_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCoat, this.coatEnchantedIdentifier);
                        }
                        if (modifiedCape != null && (checkCape = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, modifiedCape)) != null) {
                            this.etfCapeEnchantedIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_cape_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkCape, this.etfCapeEnchantedIdentifier);
                        }
                        if (noseTexture != null && (checkNose = ETFPlayerTexture.returnMatchPixels(modifiedSkin, boxChosenBounds, noseTexture)) != null) {
                            this.texturedNoseIdentifierEnchanted = new ResourceLocation(SKIN_NAMESPACE, id + "_nose_enchant.png");
                            ETFUtils2.registerNativeImageToIdentifier(checkNose, this.texturedNoseIdentifierEnchanted);
                        }
                    } else {
                        this.hasEnchant = false;
                    }
                }
                ResourceLocation modifiedSkinIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + ".png");
                ETFUtils2.registerNativeImageToIdentifier(modifiedSkin, modifiedSkinIdentifier);
                ResourceLocation modifiedSkinBlinkPatchedIdentifier = null;
                ResourceLocation modifiedSkinPatchedIdentifier = null;
                ResourceLocation modifiedSkinBlink2PatchedIdentifier = null;
                if (ETFClientCommon.ETFConfigData.removePixelsUnderEmissivePlayers && emissiveImage != null) {
                    modifiedSkinPatchedIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_e_patched.png");
                    ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(modifiedSkin, emissiveImage);
                    ETFUtils2.registerNativeImageToIdentifier(modifiedSkin, modifiedSkinPatchedIdentifier);
                    if (blinkSkinFile != null) {
                        modifiedSkinBlinkPatchedIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_blink_e_patched.png");
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(blinkSkinFile, emissiveBlinkImage);
                        ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile, modifiedSkinBlinkPatchedIdentifier);
                    }
                    if (blinkSkinFile2 != null) {
                        modifiedSkinBlink2PatchedIdentifier = new ResourceLocation(SKIN_NAMESPACE, id + "_blink2_e_patched.png");
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(blinkSkinFile2, emissiveBlink2Image);
                        ETFUtils2.registerNativeImageToIdentifier(blinkSkinFile2, modifiedSkinBlink2PatchedIdentifier);
                    }
                }
                this.etfTextureOfFinalBaseSkin = new ETFTexture(modifiedSkinIdentifier, blinkIdentifier, blink2Identifier, emissiveIdentifier, blinkEmissiveIdentifier, blink2EmissiveIdentifier, modifiedSkinPatchedIdentifier, modifiedSkinBlinkPatchedIdentifier, modifiedSkinBlink2PatchedIdentifier);
                if (this.capeType == ETFConfigScreenSkinTool.CapeType.NONE && this.etfCapeIdentifier != null && this.etfCapeEnchantedIdentifier == null && this.etfCapeEmissiveIdentifier == null) {
                    this.etfCapeIdentifier = null;
                }
                if (modifiedCape != null) {
                    modifiedCape.close();
                }
                modifiedSkin.close();
            } else {
                this.skinFailed();
            }
        } else {
            this.skinFailed();
        }
        this.isTextureReady = true;
    }

    public void changeSkinToThisForTool(NativeImage image) {
        this.etfCapeEmissiveIdentifier = null;
        this.etfCapeIdentifier = null;
        this.baseEnchantBlinkIdentifier = null;
        this.etfCapeEnchantedIdentifier = null;
        this.baseEnchantIdentifier = null;
        this.coatEmissiveIdentifier = null;
        this.coatEnchantedIdentifier = null;
        this.baseEnchantBlink2Identifier = null;
        this.etfTextureOfFinalBaseSkin = null;
        this.coatIdentifier = null;
        this.hasEmissives = false;
        this.hasEnchant = false;
        this.hasFatCoat = false;
        this.hasFeatures = false;
        this.hasVillagerNose = false;
        this.isTextureReady = false;
        this.coatStyle = 0;
        this.coatLength = 1;
        this.blinkHeight = 1;
        this.blinkType = 0;
        this.capeType = ETFConfigScreenSkinTool.CapeType.NONE;
        this.texturedNoseIdentifier = null;
        this.texturedNoseIdentifierEmissive = null;
        this.texturedNoseIdentifierEnchanted = null;
        this.noseType = ETFConfigScreenSkinTool.NoseType.NONE;
        this.originalSkin = image;
        this.checkTexture(true);
    }
}

