/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_handlers;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.utils.ETFUtils2;

public enum ETFDirectory {
    DOES_NOT_EXIST(null),
    ETF(new String[]{"textures", "etf/random"}),
    OLD_OPTIFINE(new String[]{"textures/entity", "optifine/mob"}),
    OPTIFINE(new String[]{"textures", "optifine/random"}),
    VANILLA(null);

    private static Object2ReferenceOpenHashMap<@NotNull ResourceLocation, @NotNull ETFDirectory> ETF_DIRECTORY_CACHE;
    private final String[] replaceStrings;

    private ETFDirectory(String[] replaceStrings) {
        this.replaceStrings = replaceStrings;
    }

    public static void resetCache() {
        ETF_DIRECTORY_CACHE = new Object2ReferenceOpenHashMap();
    }

    public static Object2ReferenceOpenHashMap<@NotNull ResourceLocation, @NotNull ETFDirectory> getCache() {
        if (ETF_DIRECTORY_CACHE == null) {
            ETF_DIRECTORY_CACHE = new Object2ReferenceOpenHashMap();
        }
        return ETF_DIRECTORY_CACHE;
    }

    @Nullable
    public static ResourceLocation getDirectoryVersionOf(ResourceLocation vanillaIdentifier) {
        ETFDirectory directory = ETFDirectory.getDirectoryOf(vanillaIdentifier);
        switch (directory) {
            case DOES_NOT_EXIST: {
                return null;
            }
            case VANILLA: {
                return vanillaIdentifier;
            }
        }
        return ETFUtils2.replaceIdentifier(vanillaIdentifier, directory.replaceStrings[0], directory.replaceStrings[1]);
    }

    @NotNull
    public static ETFDirectory getDirectoryOf(ResourceLocation vanillaIdentifier) {
        Object2ReferenceOpenHashMap<@NotNull ResourceLocation, @NotNull ETFDirectory> cache = ETFDirectory.getCache();
        if (!cache.containsKey((Object)vanillaIdentifier)) {
            cache.put((Object)vanillaIdentifier, (Object)ETFDirectory.findDirectoryOf(vanillaIdentifier));
        }
        return (ETFDirectory)((Object)cache.get((Object)vanillaIdentifier));
    }

    @NotNull
    private static ETFDirectory findDirectoryOf(ResourceLocation vanillaIdentifier) {
        if (vanillaIdentifier.func_110623_a().contains("etf/random/entity")) {
            if (ETFUtils2.isExistingResource(vanillaIdentifier)) {
                return ETF;
            }
        } else if (vanillaIdentifier.func_110623_a().contains("optifine/random/entity")) {
            if (ETFUtils2.isExistingResource(vanillaIdentifier)) {
                return OPTIFINE;
            }
        } else if (vanillaIdentifier.func_110623_a().contains("optifine/mob") && ETFUtils2.isExistingResource(vanillaIdentifier)) {
            return OLD_OPTIFINE;
        }
        ObjectArrayList foundDirectories = new ObjectArrayList();
        IResourceManager resources = Minecraft.func_71410_x().func_195551_G();
        if (ETFUtils2.isExistingResource(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, VANILLA))) {
            foundDirectories.add((Object)VANILLA);
        }
        if (ETFUtils2.isExistingResource(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, OLD_OPTIFINE))) {
            foundDirectories.add((Object)OLD_OPTIFINE);
        }
        if (ETFUtils2.isExistingResource(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, OPTIFINE))) {
            foundDirectories.add((Object)OPTIFINE);
        }
        if (ETFUtils2.isExistingResource(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, ETF))) {
            foundDirectories.add((Object)ETF);
        }
        if (foundDirectories.isEmpty()) {
            return DOES_NOT_EXIST;
        }
        if (foundDirectories.size() == 1) {
            return (ETFDirectory)((Object)foundDirectories.get(0));
        }
        Object2ReferenceOpenHashMap resourcePackNames = new Object2ReferenceOpenHashMap();
        for (ETFDirectory directory : foundDirectories) {
            try {
                if (!ETFUtils2.isExistingResource(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, directory))) continue;
                resourcePackNames.put((Object)resources.func_199002_a(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, directory)).func_199026_d(), (Object)directory);
            }
            catch (Exception exception) {}
        }
        String[] strArray = (String[])resourcePackNames.keySet().toArray((Object[])new String[0]);
        String returnedPack = ETFUtils2.returnNameOfHighestPackFromTheseMultiple(strArray);
        if (returnedPack != null) {
            return (ETFDirectory)((Object)resourcePackNames.get((Object)returnedPack));
        }
        return VANILLA;
    }

    @NotNull
    public static ResourceLocation getIdentifierAsDirectory(ResourceLocation identifier, ETFDirectory directory) {
        if (directory.doesReplace()) {
            return new ResourceLocation(identifier.func_110624_b(), identifier.func_110623_a().replace(directory.replaceStrings[0], directory.replaceStrings[1]));
        }
        return identifier;
    }

    public boolean doesReplace() {
        return this.replaceStrings != null;
    }

    static {
        ETF_DIRECTORY_CACHE = null;
    }
}

