/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mod_compat;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.renderlayers.BodyLayerFeatureRenderer;
import dev.tr7zw.skinlayers.renderlayers.HeadLayerFeatureRenderer;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import traben.entity_texture_features.mod_compat.ETF3DBodyLayerFeatureRenderer;
import traben.entity_texture_features.mod_compat.ETF3DHeadLayerFeatureRenderer;
import traben.entity_texture_features.utils.ETFUtils2;

public abstract class ETF3DSkinLayersUtil {
    public static boolean canReplace(LayerRenderer<?, ?> feature) {
        return feature instanceof BodyLayerFeatureRenderer || feature instanceof HeadLayerFeatureRenderer;
    }

    public static LayerRenderer<?, ?> getReplacement(LayerRenderer<?, ?> feature, IEntityRenderer<?, ?> context) {
        try {
            if (feature instanceof HeadLayerFeatureRenderer) {
                return new ETF3DHeadLayerFeatureRenderer(context);
            }
            if (feature instanceof BodyLayerFeatureRenderer) {
                return new ETF3DBodyLayerFeatureRenderer(context);
            }
        }
        catch (Exception e) {
            ETFUtils2.logWarn("Exception with ETF's 3D skin layers mod compatibility: " + e);
        }
        ETFUtils2.logError("Failed in ETF's 3D skin layers mod compatibility.");
        return feature;
    }

    public static void renderHand(PlayerRenderer instance, MatrixStack poseStack, IVertexBuilder vertexConsumer, int i, AbstractClientPlayerEntity abstractClientPlayer, ModelRenderer arm, ModelRenderer sleeve) {
        try {
            if (!sleeve.field_78806_j) {
                PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
                float pixelScaling = 1.1f;
                float armHeightScaling = 1.1f;
                if (settings.getSkinLayers() != null) {
                    CustomizableModelPart part = null;
                    boolean thinArms = ((PlayerEntityModelAccessor)instance.func_217764_d()).hasThinArms();
                    part = sleeve == ((PlayerModel)instance.func_217764_d()).field_178734_a ? settings.getSkinLayers()[2] : settings.getSkinLayers()[3];
                    part.copyFrom(arm);
                    poseStack.func_227860_a_();
                    poseStack.func_227862_a_(pixelScaling, armHeightScaling, pixelScaling);
                    part.y = (float)((double)part.y - 0.6);
                    if (!thinArms) {
                        part.x = (float)((double)part.x - 0.4);
                    }
                    part.render(poseStack, vertexConsumer, i, OverlayTexture.field_229196_a_);
                    part.setPos(0.0f, 0.0f, 0.0f);
                    part.setRotation(0.0f, 0.0f, 0.0f);
                    poseStack.func_227865_b_();
                }
            }
        }
        catch (Exception e) {
            ETFUtils2.logWarn("Exception with ETF's 3D skin layers mod hand compatibility: " + e);
        }
        catch (NoClassDefFoundError error) {
            ETFUtils2.logError("Error with ETF's 3D skin layers mod hand compatibility: " + error);
        }
    }
}

