/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.renderer.feature;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.MooshroomMushroomLayer;
import net.minecraft.client.renderer.entity.model.CowModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

@Mixin(value={MooshroomMushroomLayer.class})
public abstract class MixinMooshroomMushroomFeatureRenderer {
    private static final ResourceLocation RED_SHROOM = new ResourceLocation("textures/entity/cow/red_mushroom.png");
    private static final ResourceLocation BROWN_SHROOM = new ResourceLocation("textures/entity/cow/brown_mushroom.png");
    private static final ModelRenderer[] shroomAsEntityModel = MixinMooshroomMushroomFeatureRenderer.getModelData();
    private static ResourceLocation redEmissive = null;
    private static ResourceLocation brownEmissive = null;

    private static ModelRenderer[] getModelData() {
        ModelRenderer shroom1 = new ModelRenderer((Model)new CowModel()).func_78787_b(64, 64);
        shroom1.func_78784_a(32, 16).func_228301_a_(0.0f, 0.0f, 8.0f, 16.0f, 16.0f, 0.0f, 0.0f);
        ModelRenderer shroom2 = new ModelRenderer((Model)new CowModel()).func_78787_b(64, 64);
        shroom1.func_78784_a(32, 16).func_228301_a_(8.0f, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f);
        return new ModelRenderer[]{shroom1, shroom2};
    }

    @Nullable
    private static Boolean returnRedTrueBrownFalseVanillaNull(BlockState mushroomState) {
        if (ETFClientCommon.ETFConfigData.enableCustomTextures) {
            if (mushroomState.func_203425_a(Blocks.field_150337_Q)) {
                switch (ETFManager.getInstance().mooshroomRedCustomShroom) {
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return true;
                    }
                }
                if (ETFUtils2.isExistingResource(RED_SHROOM)) {
                    ETFManager.getInstance().mooshroomRedCustomShroom = 2;
                    return MixinMooshroomMushroomFeatureRenderer.prepareMushroomTextures(true);
                }
                ETFManager.getInstance().mooshroomRedCustomShroom = 1;
            } else if (mushroomState.func_203425_a(Blocks.field_150338_P)) {
                switch (ETFManager.getInstance().mooshroomBrownCustomShroom) {
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return false;
                    }
                }
                if (ETFUtils2.isExistingResource(BROWN_SHROOM)) {
                    ETFManager.getInstance().mooshroomBrownCustomShroom = 2;
                    return MixinMooshroomMushroomFeatureRenderer.prepareMushroomTextures(false);
                }
                ETFManager.getInstance().mooshroomBrownCustomShroom = 1;
            }
        }
        return null;
    }

    private static Boolean prepareMushroomTextures(boolean isRed) {
        return MixinMooshroomMushroomFeatureRenderer.prepareMushroomTextures(isRed, false);
    }

    private static Boolean prepareMushroomTextures(boolean isRed, boolean doingEmissive) {
        NativeImage originalImagePreFlip;
        ResourceLocation idOfOriginal = isRed ? RED_SHROOM : BROWN_SHROOM;
        String suffix = null;
        if (doingEmissive) {
            boolean found = false;
            for (String str : ETFManager.getInstance().EMISSIVE_SUFFIX_LIST) {
                ResourceLocation test = new ResourceLocation(idOfOriginal.toString().replace(".png", str + ".png"));
                if (!ETFUtils2.isExistingResource(test)) continue;
                suffix = str;
                idOfOriginal = test;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        if ((originalImagePreFlip = ETFUtils2.getNativeImageElseNull(idOfOriginal)) != null) {
            try {
                ResourceLocation idOfNew;
                NativeImage newImage;
                try (NativeImage flippedOriginalImage = ETFUtils2.emptyNativeImage(originalImagePreFlip.func_195702_a(), originalImagePreFlip.func_195714_b());){
                    int y;
                    int x;
                    for (x = 0; x < flippedOriginalImage.func_195702_a(); ++x) {
                        for (y = 0; y < flippedOriginalImage.func_195714_b(); ++y) {
                            flippedOriginalImage.func_195700_a(x, y, originalImagePreFlip.func_195709_a(x, originalImagePreFlip.func_195714_b() - 1 - y));
                        }
                    }
                    newImage = ETFUtils2.emptyNativeImage(flippedOriginalImage.func_195702_a() * 2, flippedOriginalImage.func_195714_b());
                    for (x = 0; x < newImage.func_195702_a(); ++x) {
                        for (y = 0; y < newImage.func_195714_b(); ++y) {
                            if (x < flippedOriginalImage.func_195702_a()) {
                                newImage.func_195700_a(x, y, flippedOriginalImage.func_195709_a(x, y));
                                continue;
                            }
                            newImage.func_195700_a(x, y, flippedOriginalImage.func_195709_a(flippedOriginalImage.func_195702_a() - 1 - (x - flippedOriginalImage.func_195702_a()), y));
                        }
                    }
                }
                ResourceLocation resourceLocation = idOfNew = isRed ? new ResourceLocation("etf", "red_shroom_alt.png") : new ResourceLocation("etf", "brown_shroom_alt.png");
                if (doingEmissive && suffix != null) {
                    ResourceLocation emissive = new ResourceLocation(idOfNew.toString().replace(".png", suffix + ".png"));
                    ETFUtils2.registerNativeImageToIdentifier(newImage, emissive);
                    if (isRed) {
                        redEmissive = emissive;
                    } else {
                        brownEmissive = emissive;
                    }
                } else {
                    ETFUtils2.registerNativeImageToIdentifier(newImage, idOfNew);
                }
                if (!doingEmissive) {
                    MixinMooshroomMushroomFeatureRenderer.prepareMushroomTextures(isRed, true);
                    if (isRed) {
                        ETFManager.getInstance().redMooshroomAlt = new ETFTexture(idOfNew, redEmissive);
                    } else {
                        ETFManager.getInstance().brownMooshroomAlt = new ETFTexture(idOfNew, brownEmissive);
                    }
                }
                return isRed;
            }
            catch (Exception e) {
                ETFUtils2.logError("Mooshroom custom mushroom texture could not be loaded. " + e);
            }
        }
        return null;
    }

    @Redirect(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/passive/MooshroomEntity;FFFFFF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/block/BlockRenderManager;renderBlockAsEntity(Lnet/minecraft/block/BlockState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V"))
    private void etf$injected(BlockRendererDispatcher instance, BlockState state, MatrixStack matrices, IRenderTypeBuffer vertexConsumer, int light, int overlay) {
        Boolean shroomType = MixinMooshroomMushroomFeatureRenderer.returnRedTrueBrownFalseVanillaNull(state);
        if (shroomType != null) {
            ETFTexture thisTexture;
            ETFTexture eTFTexture = thisTexture = shroomType != false ? ETFManager.getInstance().redMooshroomAlt : ETFManager.getInstance().brownMooshroomAlt;
            if (thisTexture != null) {
                for (ModelRenderer model : shroomAsEntityModel) {
                    IVertexBuilder texturedConsumer = vertexConsumer.getBuffer(RenderType.func_228638_b_((ResourceLocation)thisTexture.thisIdentifier));
                    model.func_228309_a_(matrices, texturedConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    thisTexture.renderEmissive(matrices, vertexConsumer, model);
                }
            }
        }
    }
}

