/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.block_entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.BedTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.mixin.accessor.SpriteAccessor;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFPlaceholderEntity;

@Mixin(value={BedTileEntityRenderer.class})
public abstract class MixinBedBlockEntityRenderer
extends TileEntityRenderer<BedTileEntity> {
    @Shadow
    @Final
    private ModelRenderer field_228843_a_;
    @Shadow
    @Final
    private ModelRenderer field_228844_c_;
    @Shadow
    @Final
    private ModelRenderer[] field_228845_d_;
    private boolean isAnimatedTexture = false;
    private ETFTexture thisETFTexture = null;
    private ETFPlaceholderEntity etf$bedStandInDummy = null;
    private ResourceLocation etf$textureOfThis = null;
    private IRenderTypeBuffer etf$vertexConsumerProviderOfThis = null;

    public MixinBedBlockEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @ModifyArg(method={"method_3558"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/ModelPart;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;II)V"), index=1)
    private IVertexBuilder etf$alterTexture(IVertexBuilder vertices) {
        try {
            if (this.isAnimatedTexture || !ETFClientCommon.ETFConfigData.enableCustomTextures || !ETFClientCommon.ETFConfigData.enableCustomBlockEntities) {
                return vertices;
            }
            this.thisETFTexture = ETFManager.getInstance().getETFTexture(this.etf$textureOfThis, this.etf$bedStandInDummy, ETFManager.TextureSource.BLOCK_ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveBlockEntity);
            IVertexBuilder alteredReturn = this.thisETFTexture == null ? null : this.etf$vertexConsumerProviderOfThis.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.thisETFTexture.getTextureIdentifier(this.etf$bedStandInDummy)));
            return alteredReturn == null ? vertices : alteredReturn;
        }
        catch (Exception e) {
            return vertices;
        }
    }

    @Inject(method={"render(Lnet/minecraft/block/entity/BedBlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/BedBlockEntity;getWorld()Lnet/minecraft/world/World;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void etf$getChestTexture(BedTileEntity bedBlockEntity, float f, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i, int j, CallbackInfo ci, RenderMaterial spriteIdentifier) {
        try {
            boolean bl = this.isAnimatedTexture = ((SpriteAccessor)spriteIdentifier.func_229314_c_()).callGetFrameCount() != 1;
            if (!this.isAnimatedTexture) {
                String nameSpace = spriteIdentifier.func_229313_b_().func_110624_b();
                String texturePath = "textures/" + spriteIdentifier.func_229313_b_().func_110623_a() + ".png";
                this.etf$textureOfThis = new ResourceLocation(nameSpace, texturePath);
                this.etf$vertexConsumerProviderOfThis = vertexConsumerProvider;
                if (ETFClientCommon.ETFConfigData.enableCustomTextures && ETFClientCommon.ETFConfigData.enableCustomBlockEntities) {
                    World worldCheck = bedBlockEntity.func_145831_w();
                    if (worldCheck == null) {
                        worldCheck = Minecraft.func_71410_x().field_71441_e;
                    }
                    if (worldCheck != null) {
                        this.etf$bedStandInDummy = ETFPlaceholderEntity.newFromJustWorld(worldCheck);
                        this.etf$bedStandInDummy.prepare((TileEntity)bedBlockEntity, UUID.nameUUIDFromBytes((bedBlockEntity.func_174877_v().toString() + bedBlockEntity.func_193048_a().toString()).getBytes()));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"method_3558"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;pop()V", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void etf$applyEmissiveBed(MatrixStack matrix, IRenderTypeBuffer vertexConsumerProvider, boolean bl, Direction direction, RenderMaterial spriteIdentifier, int light, int overlay, boolean bl2, CallbackInfo ci, IVertexBuilder vertexConsumer) {
        try {
            if (!this.isAnimatedTexture && ETFClientCommon.ETFConfigData.enableEmissiveBlockEntities && this.thisETFTexture != null) {
                this.thisETFTexture.renderEmissive(matrix, vertexConsumerProvider, this.field_228843_a_, ETFManager.EmissiveRenderModes.blockEntityMode());
                this.thisETFTexture.renderEmissive(matrix, vertexConsumerProvider, this.field_228844_c_, ETFManager.EmissiveRenderModes.blockEntityMode());
                this.thisETFTexture.renderEmissive(matrix, vertexConsumerProvider, this.field_228845_d_[0], ETFManager.EmissiveRenderModes.blockEntityMode());
                this.thisETFTexture.renderEmissive(matrix, vertexConsumerProvider, this.field_228845_d_[1], ETFManager.EmissiveRenderModes.blockEntityMode());
                this.thisETFTexture.renderEmissive(matrix, vertexConsumerProvider, this.field_228845_d_[2], ETFManager.EmissiveRenderModes.blockEntityMode());
                this.thisETFTexture.renderEmissive(matrix, vertexConsumerProvider, this.field_228845_d_[3], ETFManager.EmissiveRenderModes.blockEntityMode());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

