/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.forge;

import java.io.File;
import java.util.Objects;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.forge.ETFClientForge;
import traben.entity_texture_features.forge.oculusCompat;
import traben.entity_texture_features.utils.ETFPlaceholderEntity;

public class ETFVersionDifferenceHandlerImpl {
    public static boolean isThisModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static File getConfigDir() {
        return FMLPaths.GAMEDIR.get().resolve(FMLPaths.CONFIGDIR.get()).toFile();
    }

    public static boolean isForge() {
        return true;
    }

    public static boolean isFabric() {
        return false;
    }

    public static boolean areShadersInUse() {
        return oculusCompat.isShaderPackInUse();
    }

    public static Logger getLogger() {
        return LogManager.getLogger((String)"Entity Texture Features");
    }

    public static ITextComponent getTextFromTranslation(String translationKey) {
        return new TranslationTextComponent(translationKey);
    }

    public static String getBiomeString(World world, BlockPos pos) {
        return Objects.requireNonNull(world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)world.func_226691_t_(pos))).toString();
    }

    @NotNull
    public static EntityType<ETFPlaceholderEntity> getPlaceHolderEntityType() {
        return (EntityType)ETFClientForge.ETF_PLACEHOLDER_ENTITY_ENTITY_REGISTRY.get();
    }
}

