/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.config.screens.ETFConfigScreenSkinTool;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolPixelSelection
extends ETFConfigScreen {
    private final SelectionMode MODE;
    private final ETFConfigScreenSkinTool etfParent;
    Set<Integer> selectedPixels;
    ResourceLocation currentSkinToRender = new ResourceLocation("entity_texture_features:textures/gui/icon.png");

    protected ETFConfigScreenSkinToolPixelSelection(ETFConfigScreenSkinTool parent, SelectionMode mode) {
        super(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features" + (mode == SelectionMode.EMISSIVE ? ".emissive_select" : ".enchanted_select") + ".title"), parent);
        this.MODE = mode;
        this.etfParent = parent;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        ResourceLocation randomID = new ResourceLocation("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
        if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID)) {
            this.currentSkinToRender = randomID;
        }
        this.selectedPixels = new HashSet<Integer>();
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                int color = this.etfParent.currentEditorSkin.func_195709_a(x, y);
                if (color == 0) continue;
                this.selectedPixels.add(color);
            }
        }
        this.func_230480_a_((Widget)this.getETFButton((int)((double)this.field_230708_k_ * 0.024), (int)((double)this.field_230709_l_ * 0.2), 20, 20, ITextComponent.func_244388_a((String)"\u27f3"), button -> {
            this.etfParent.flipView = !this.etfParent.flipView;
        }));
        this.func_230480_a_((Widget)this.getETFButton((int)((double)this.field_230708_k_ * 0.55), (int)((double)this.field_230709_l_ * 0.9), (int)((double)this.field_230708_k_ * 0.2), 20, DialogTexts.field_240637_h_, button -> Objects.requireNonNull(this.field_230706_i_).func_147108_a(this.parent)));
        int pixelSize = (int)((double)this.field_230709_l_ * 0.7 / 64.0);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                int finalX = x;
                int finalY = y;
                Button butt = new Button((int)((double)this.field_230708_k_ * 0.35 + (double)(x * pixelSize)), (int)((double)this.field_230709_l_ * 0.2 + (double)(y * pixelSize)), pixelSize, pixelSize, ITextComponent.func_244388_a((String)""), button -> {
                    int colorAtPixel = this.etfParent.currentEditorSkin.func_195709_a(finalX, finalY);
                    if (this.selectedPixels.contains(colorAtPixel)) {
                        this.selectedPixels.remove(colorAtPixel);
                    } else {
                        this.selectedPixels.add(colorAtPixel);
                    }
                    this.applyCurrentSelectedPixels();
                    this.etfParent.thisETFPlayerTexture.changeSkinToThisForTool(this.etfParent.currentEditorSkin);
                    ResourceLocation randomID2 = new ResourceLocation("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
                    if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID2)) {
                        this.currentSkinToRender = randomID2;
                    }
                }, null){

                    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
                    }
                };
                this.func_230480_a_((Widget)butt);
            }
        }
    }

    private void applyCurrentSelectedPixels() {
        ArrayList<Integer> integerSet = new ArrayList<Integer>(this.selectedPixels);
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                if (integerSet.isEmpty()) {
                    this.etfParent.currentEditorSkin.func_195700_a(x, y, 0);
                    continue;
                }
                this.etfParent.currentEditorSkin.func_195700_a(x, y, integerSet.get(0).intValue());
                integerSet.remove(0);
            }
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        int pixelSize = (int)((double)this.field_230709_l_ * 0.7 / 64.0);
        ETFConfigScreenSkinToolPixelSelection.renderGUITexture(this.currentSkinToRender, (int)((double)this.field_230708_k_ * 0.35), (int)((double)this.field_230709_l_ * 0.2), (int)((double)this.field_230708_k_ * 0.35 + (double)(64 * pixelSize)), (int)((double)this.field_230709_l_ * 0.2 + (double)(64 * pixelSize)));
        ETFConfigScreenSkinToolPixelSelection.func_238475_b_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.skin_select" + (this.selectedPixels.size() > 64 ? ".warn" : ".hint")), (int)(this.field_230708_k_ / 7), (int)((int)((double)this.field_230709_l_ * 0.8)), (int)(this.selectedPixels.size() > 64 ? 0xFF1515 : 0xFFFFFF));
        if (Minecraft.func_71410_x() != null) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                int blinkModifierBySystemTimeInTicks = (int)(System.currentTimeMillis() / 50L % (long)(30 + ETFClientCommon.ETFConfigData.blinkLength * 2));
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)player.func_110124_au(), player.field_70170_p.func_82737_E() + (long)blinkModifierBySystemTimeInTicks - (long)(15 + ETFClientCommon.ETFConfigData.blinkLength));
                int height = (int)((double)this.field_230709_l_ * 0.75);
                int playerX = (int)((double)this.field_230708_k_ * 0.14);
                this.drawEntity(playerX, height, (int)((double)this.field_230709_l_ * 0.3), -mouseX + playerX, (float)((double)(-mouseY) + (double)this.field_230709_l_ * 0.3), (LivingEntity)player);
            } else {
                ETFConfigScreenSkinToolPixelSelection.func_238475_b_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)ITextComponent.func_244388_a((String)"Player model only visible while in game!"), (int)(this.field_230708_k_ / 7), (int)((int)((double)this.field_230709_l_ * 0.4)), (int)0xFFFFFF);
                ETFConfigScreenSkinToolPixelSelection.func_238475_b_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)ITextComponent.func_244388_a((String)"load a single-player world and then open this menu."), (int)(this.field_230708_k_ / 7), (int)((int)((double)this.field_230709_l_ * 0.45)), (int)0xFFFFFF);
            }
        }
    }

    public void drawEntity(int x, int y, int size, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_((float)size, (float)size, (float)size);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion2 = Vector3f.field_229179_b_.func_229187_a_(g * 20.0f);
        quaternion.func_195890_a(quaternion2);
        matrixStack.func_227863_a_(quaternion);
        float h = entity.field_70761_aq;
        float i = entity.field_70177_z;
        float j = entity.field_70125_A;
        float k = entity.field_70758_at;
        float l = entity.field_70759_as;
        entity.field_70761_aq = (this.etfParent.flipView ? 0.0f : 180.0f) + f * 20.0f;
        entity.field_70177_z = (this.etfParent.flipView ? 0.0f : 180.0f) + f * 40.0f;
        entity.field_70125_A = -g * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager entityRenderDispatcher = Minecraft.func_71410_x().func_175598_ae();
        quaternion2.func_195892_e();
        entityRenderDispatcher.func_229089_a_(quaternion2);
        entityRenderDispatcher.func_178633_a(false);
        IRenderTypeBuffer.Impl immediate = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)immediate, 0x800080));
        immediate.func_228461_a_();
        IRenderTypeBuffer.Impl immediate2 = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> {
            EntityRenderer bob;
            RenderType layer;
            IVertexBuilder vertexC;
            ResourceLocation emissive;
            if (this.etfParent.thisETFPlayerTexture != null && this.etfParent.thisETFPlayerTexture.etfTextureOfFinalBaseSkin != null && entity instanceof AbstractClientPlayerEntity && (emissive = this.etfParent.thisETFPlayerTexture.etfTextureOfFinalBaseSkin.getEmissiveIdentifierOfCurrentState()) != null && (vertexC = immediate.getBuffer(layer = RenderType.func_228644_e_((ResourceLocation)emissive))) != null && (bob = entityRenderDispatcher.func_78713_a((Entity)entity)) instanceof LivingRenderer) {
                ((LivingRenderer)bob).func_217764_d().func_225598_a_(matrixStack, vertexC, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
        immediate2.func_228461_a_();
        entityRenderDispatcher.func_178633_a(true);
        entity.field_70761_aq = h;
        entity.field_70177_z = i;
        entity.field_70125_A = j;
        entity.field_70758_at = k;
        entity.field_70759_as = l;
        RenderSystem.popMatrix();
    }

    public static enum SelectionMode {
        EMISSIVE(56, 16),
        ENCHANTED(56, 24);

        final int startX;
        final int startY;

        private SelectionMode(int start_x, int start_y) {
            this.startX = start_x;
            this.startY = start_y;
        }
    }
}

