/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderSkybox;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ETFConfigScreen
extends Screen {
    static final RenderSkybox backgroundCube = new RenderSkybox(new RenderSkyboxCube(new ResourceLocation("entity_texture_features:textures/gui/background/panorama")));
    final Screen parent;

    public ETFConfigScreen(ITextComponent text, Screen parent) {
        super(text);
        this.parent = parent;
    }

    public static void renderGUITexture(ResourceLocation texture, double x1, double y1, double x2, double y2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferBuilder.func_225582_a_(x1, y2, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferBuilder.func_225582_a_(x2, y2, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferBuilder.func_225582_a_(x2, y1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferBuilder.func_225582_a_(x1, y1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferBuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
    }

    public static void renderBackgroundTexture(int vOffset, ResourceLocation texture, int height, int width) {
        ETFConfigScreen.renderBackgroundTexture(vOffset, texture, height, width, 0);
    }

    public static void renderBackgroundTexture(int vOffset, ResourceLocation texture, int height, int width, int minHeight) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferBuilder.func_225582_a_(0.0, (double)height, 0.0).func_225583_a_(0.0f, (float)height / 32.0f + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferBuilder.func_225582_a_((double)width, (double)height, 0.0).func_225583_a_((float)width / 32.0f, (float)height / 32.0f + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferBuilder.func_225582_a_((double)width, (double)minHeight, 0.0).func_225583_a_((float)width / 32.0f, (float)minHeight / 32.0f + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferBuilder.func_225582_a_(0.0, (double)minHeight, 0.0).func_225583_a_(0.0f, (float)minHeight / 32.0f + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_231175_as__() {
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_147108_a(this.parent);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        backgroundCube.func_217623_a(0.5f, 1.0f);
        ETFConfigScreen.renderBackgroundTexture(0, new ResourceLocation("textures/gui/options_background.png"), (int)((double)this.field_230709_l_ * 0.15), this.field_230708_k_);
        ETFConfigScreen.renderBackgroundTexture(0, new ResourceLocation("textures/gui/options_background.png"), this.field_230709_l_, this.field_230708_k_, (int)((double)this.field_230709_l_ * 0.85));
        this.func_238468_a_(matrices, 0, (int)((double)this.field_230709_l_ * 0.15), this.field_230708_k_, (int)((double)this.field_230709_l_ * 0.85), -1072689136, -804253680);
        ETFConfigScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)15, (int)0xFFFFFF);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    Button getETFButton(int x, int y, int width, int height, ITextComponent buttonText, Button.IPressable onPress) {
        return this.getETFButton(x, y, width, height, buttonText, onPress, ITextComponent.func_244388_a((String)""));
    }

    Button getETFButton(int x, int y, int width, int height, ITextComponent buttonText, Button.IPressable onPress, ITextComponent toolTipText) {
        int nudgeLeftEdge;
        if (width > 384) {
            nudgeLeftEdge = (width - 384) / 2;
            width = 384;
        } else {
            nudgeLeftEdge = 0;
        }
        boolean tooltipIsEmpty = toolTipText.getString().isEmpty();
        String[] strings = toolTipText.getString().split("\n");
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
        for (String str : strings) {
            lines.add(ITextComponent.func_244388_a((String)str.trim()));
        }
        return new Button(x + nudgeLeftEdge, y, width, height, buttonText, onPress, (buttonWidget, matrices, mouseX, mouseY) -> {
            if (buttonWidget.func_230449_g_() && !tooltipIsEmpty) {
                this.func_243308_b(matrices, lines, mouseX, mouseY);
            }
        });
    }
}

