/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.world;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.common.util.math.matrix.ChildVecOrigin;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.matrix.VecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.world.CreativeWorld;
import team.creative.creativecore.common.world.IOrientatedWorld;
import team.creative.creativecore.common.world.SubWorldServer;

public class SubWorld
extends CreativeWorld {
    public World parentWorld;
    public IVecOrigin origin;
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender;

    public static SubWorld createFakeWorld(World world) {
        if (world instanceof ServerWorld) {
            return new SubWorldServer(world, 6);
        }
        return new SubWorld(world, 6);
    }

    protected SubWorld(World parent, int radius) {
        super((ISpawnWorldInfo)parent.func_72912_H(), radius, parent.func_234924_Y_(), parent.field_72995_K, parent.func_234925_Z_(), 0L);
        this.parentWorld = parent;
        this.gatherCapabilities();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)this));
    }

    @Override
    public IVecOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Vec3d center) {
        this.origin = this.parentWorld instanceof IOrientatedWorld ? new ChildVecOrigin(((IOrientatedWorld)this.parentWorld).getOrigin(), center) : new VecOrigin(center);
    }

    @Override
    public boolean hasParent() {
        return true;
    }

    @Override
    public World getParent() {
        return this.parentWorld;
    }

    @Override
    public World getRealWorld() {
        if (this.parentWorld instanceof SubWorld) {
            return ((SubWorld)this.parentWorld).getRealWorld();
        }
        return this.parentWorld;
    }

    public void func_184133_a(@Nullable PlayerEntity p_184133_1_, BlockPos pos, SoundEvent p_184133_3_, SoundCategory p_184133_4_, float p_184133_5_, float p_184133_6_) {
        if (this.getOrigin() == null) {
            return;
        }
        this.getRealWorld().func_184133_a(p_184133_1_, this.transformToRealWorld(pos), p_184133_3_, p_184133_4_, p_184133_5_, p_184133_6_);
    }

    public void func_184148_a(@Nullable PlayerEntity p_184148_1_, double x, double y, double z, SoundEvent p_184148_8_, SoundCategory p_184148_9_, float p_184148_10_, float p_184148_11_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = new Vector3d(x, y, z);
        this.getOrigin().transformPointToWorld(vec);
        this.getRealWorld().func_184148_a(p_184148_1_, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, p_184148_8_, p_184148_9_, p_184148_10_, p_184148_11_);
    }

    public void func_217384_a(@Nullable PlayerEntity p_217384_1_, Entity entity, SoundEvent p_217384_3_, SoundCategory p_217384_4_, float p_217384_5_, float p_217384_6_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(entity.func_242282_l(1.0f));
        this.getRealWorld().func_184148_a(p_217384_1_, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, p_217384_3_, p_217384_4_, p_217384_5_, p_217384_6_);
    }

    public void func_184134_a(double x, double y, double z, SoundEvent p_184134_7_, SoundCategory p_184134_8_, float p_184134_9_, float p_184134_10_, boolean p_184134_11_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealWorld().func_184134_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, p_184134_7_, p_184134_8_, p_184134_9_, p_184134_10_, p_184134_11_);
    }

    public void func_195594_a(IParticleData p_195594_1_, double x, double y, double z, double p_195594_8_, double p_195594_10_, double p_195594_12_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealWorld().func_195594_a(p_195594_1_, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, p_195594_8_, p_195594_10_, p_195594_12_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195590_a(IParticleData p_195590_1_, boolean p_195590_2_, double x, double y, double z, double p_195590_9_, double p_195590_11_, double p_195590_13_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealWorld().func_195590_a(p_195590_1_, p_195590_2_, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, p_195590_9_, p_195590_11_, p_195590_13_);
    }

    public void func_195589_b(IParticleData p_195589_1_, double x, double y, double z, double p_195589_8_, double p_195589_10_, double p_195589_12_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealWorld().func_195589_b(p_195589_1_, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, p_195589_8_, p_195589_10_, p_195589_12_);
    }

    public void func_217404_b(IParticleData p_217404_1_, boolean p_217404_2_, double x, double y, double z, double p_217404_9_, double p_217404_11_, double p_217404_13_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealWorld().func_217404_b(p_217404_1_, p_217404_2_, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, p_217404_9_, p_217404_11_, p_217404_13_);
    }

    public Biome func_225604_a_(int p_225604_1_, int p_225604_2_, int p_225604_3_) {
        return this.getRealWorld().func_225604_a_(p_225604_1_, p_225604_2_, p_225604_3_);
    }

    public float func_230487_a_(Direction direction, boolean p_230487_2_) {
        return this.getRealWorld().func_230487_a_(direction, p_230487_2_);
    }

    public Scoreboard func_96441_U() {
        return this.getRealWorld().func_96441_U();
    }

    public RecipeManager func_199532_z() {
        return this.getRealWorld().func_199532_z();
    }

    public ITagCollectionSupplier func_205772_D() {
        return this.getRealWorld().func_205772_D();
    }

    public void func_217378_a(PlayerEntity player, int p_217378_2_, BlockPos pos, int p_217378_4_) {
        this.getRealWorld().func_217378_a(player, p_217378_2_, pos, p_217378_4_);
    }

    public DynamicRegistries func_241828_r() {
        return this.getRealWorld().func_241828_r();
    }
}

