/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.text.ItemStackTextComponent;
import team.creative.creativecore.common.util.text.LinebreakTextComponent;

public class TextBuilder {
    private static NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
    private final List<ITextComponent> components = new ArrayList<ITextComponent>();

    public TextBuilder() {
    }

    public TextBuilder add(ITextComponent component) {
        if (this.components.isEmpty()) {
            this.components.add(component);
        } else {
            ITextComponent last = this.components.get(this.components.size() - 1);
            if (last instanceof TextComponent) {
                ((TextComponent)last).func_230529_a_(component);
            } else {
                this.components.add(component);
            }
        }
        return this;
    }

    public TextBuilder(String text) {
        this.text(text);
    }

    public TextBuilder translateIfCan(String text) {
        String translated = GuiControl.translate(text, new Object[0]);
        if (!translated.equals(text)) {
            this.add((ITextComponent)new TranslationTextComponent(text));
        }
        return this;
    }

    public TextBuilder translate(String text) {
        this.add((ITextComponent)new TranslationTextComponent(text));
        return this;
    }

    public TextBuilder translate(String text, Object ... param) {
        this.add((ITextComponent)new TranslationTextComponent(text, param));
        return this;
    }

    public TextBuilder text(String text) {
        this.add((ITextComponent)new StringTextComponent(text));
        return this;
    }

    public TextBuilder number(float number) {
        return this.number(number, false);
    }

    public TextBuilder number(float number, boolean rounded) {
        if (rounded) {
            this.text("" + Math.round(number));
        } else {
            this.text("" + format.format(number));
        }
        return this;
    }

    public TextBuilder number(double number) {
        return this.number(number, false);
    }

    public TextBuilder number(double number, boolean rounded) {
        if (rounded) {
            this.text("" + Math.round(number));
        } else {
            this.text("" + format.format(number));
        }
        return this;
    }

    public TextBuilder newLine() {
        this.components.add(new LinebreakTextComponent());
        return this;
    }

    public TextBuilder color(int color) {
        int r = ColorUtils.getRed(color);
        int g = ColorUtils.getGreen(color);
        int b = ColorUtils.getBlue(color);
        int a = ColorUtils.getAlpha(color);
        this.text("" + TextFormatting.RED + r + " " + TextFormatting.GREEN + g + " " + TextFormatting.BLUE + b + (a < 255 ? " " + TextFormatting.WHITE + a : ""));
        return this;
    }

    public TextBuilder stack(ItemStack stack) {
        this.add(new ItemStackTextComponent(stack));
        return this;
    }

    public List<ITextComponent> build() {
        return this.components;
    }
}

