/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.layout;

import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.layout.GuiLayoutControl;

public class GuiHBox
extends GuiLayoutControl {
    public GuiHBox(String name, int x, int y, Align align, VAlign valign) {
        super(name, x, y, 1, 1, align, valign);
    }

    public GuiHBox(String name, int x, int y, VAlign valign) {
        super(name, x, y, 1, 1, Align.LEFT, valign);
    }

    public GuiHBox(String name, int x, int y) {
        super(name, x, y, 1, 1, Align.LEFT, VAlign.TOP);
    }

    @Override
    public int getPreferredWidth() {
        if (this.align != Align.LEFT) {
            return Integer.MAX_VALUE;
        }
        int width = -this.spacing;
        for (GuiControl control : this) {
            width += control.getPreferredWidth() + this.spacing;
        }
        return width;
    }

    @Override
    public void updateLayout(int width, int height) {
        int availableWidth = width / this.size();
        int xOffset = 0;
        for (GuiControl control : this) {
            if (this.align == Align.STRETCH) {
                control.setWidthLayout(availableWidth);
            } else {
                control.setWidthLayout(Math.min(control.getPreferredWidth(), availableWidth));
            }
            control.setX(xOffset);
            xOffset += control.getWidth() + this.spacing;
        }
        for (GuiControl control : this) {
            if (this.valign == VAlign.STRETCH) {
                control.setHeightLayout(height);
            } else {
                control.setHeightLayout(Math.min(control.getPreferredHeight(), height));
            }
            switch (this.valign) {
                case TOP: 
                case STRETCH: {
                    control.setY(0);
                    break;
                }
                case CENTER: {
                    control.setY(height / 2 - control.getHeight() / 2);
                    break;
                }
                case BOTTOM: {
                    control.setY(height - control.getHeight());
                }
            }
        }
        this.updatePositions(width, xOffset -= this.spacing);
        this.setHeight(height);
    }

    protected void updatePositions(int availableWidth, int xOffset) {
        if (this.align != Align.LEFT && this.align != Align.STRETCH) {
            int x = 0;
            for (GuiControl control : this) {
                switch (this.align) {
                    case CENTER: {
                        control.setX(availableWidth / 2 - xOffset / 2 + x);
                        break;
                    }
                    case RIGHT: {
                        control.setX(availableWidth - xOffset + x);
                    }
                }
                x += control.getWidth() + this.spacing;
            }
        } else {
            this.setWidth(xOffset);
        }
    }

    @Override
    public void setWidthLayout(int width) {
        int maxWidth = width / this.size();
        for (GuiControl control : this) {
            if (this.align == Align.STRETCH) {
                control.setWidthLayout(maxWidth);
                continue;
            }
            control.setWidthLayout(Math.min(control.getPreferredWidth(), maxWidth));
        }
        this.setWidth(width);
    }

    @Override
    public void setHeightLayout(int height) {
        this.updateLayout(this.getWidth(), height);
    }
}

