/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.GuiComboBoxExtension;
import team.creative.creativecore.common.gui.controls.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.ITextCollection;

public class GuiComboBox
extends GuiLabel {
    protected boolean autosize;
    public int color = -1;
    protected GuiComboBoxExtension extension;
    public CompiledText[] lines;
    private int index;

    public GuiComboBox(String name, int x, int y, ITextCollection builder) {
        super(name, x, y);
        this.lines = builder.build();
        if (this.index >= this.lines.length) {
            this.index = 0;
        }
        this.updateDisplay();
    }

    @Override
    public void tick() {
    }

    @Override
    public void closed() {
    }

    protected void updateDisplay() {
        this.text = this.lines[this.index];
    }

    @Override
    public void setWidthLayout(int width) {
        int contentOffset = this.getContentOffset() * 2;
        int height = 0;
        for (CompiledText text : this.lines) {
            text.setDimension(width, Integer.MAX_VALUE);
            height = Math.max(height, text.getTotalHeight() + contentOffset);
        }
        this.setWidth(width);
    }

    @Override
    public void setHeightLayout(int height) {
        for (CompiledText text : this.lines) {
            text.setMaxHeight(height);
        }
        this.setHeight(height);
    }

    @Override
    public int getPreferredWidth() {
        int contentOffset = this.getContentOffset() * 2;
        int width = 0;
        for (CompiledText text : this.lines) {
            width = Math.max(width, text.getTotalWidth() + contentOffset);
        }
        return width;
    }

    @Override
    public int getPreferredHeight() {
        int contentOffset = this.getContentOffset() * 2;
        int height = 0;
        for (CompiledText text : this.lines) {
            height = Math.max(height, text.getTotalHeight() + contentOffset);
        }
        return height;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean select(int index) {
        if (index >= 0 && index < this.lines.length) {
            this.index = index;
            this.updateDisplay();
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (this.extension == null) {
            this.openBox();
        } else {
            this.closeBox();
        }
        GuiComboBox.playSound(SoundEvents.field_187909_gi);
        return true;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(MatrixStack matrix, Rect rect, int mouseX, int mouseY) {
        matrix.func_227861_a_(rect.getWidth() / 2.0 - (double)(this.text.usedWidth / 2), rect.getHeight() / 2.0 - (double)(this.text.usedHeight / 2), 0.0);
        this.text.render(matrix);
    }

    public void openBox() {
        this.extension = this.createBox();
        GuiLayer layer = this.getLayer();
        layer.add(this.extension);
        this.extension.moveTop();
        this.extension.init();
        this.extension.setX(this.getControlOffsetX());
        this.extension.setY(this.getControlOffsetY() + this.getHeight());
        if (this.extension.getY() + this.extension.getHeight() > layer.getHeight() && this.getY() >= this.extension.getHeight()) {
            this.extension.setY(this.extension.getY() - this.getHeight() + this.extension.getHeight());
        }
    }

    protected GuiComboBoxExtension createBox() {
        return new GuiComboBoxExtension(this.name + "extension", this, this.getX(), this.getY() + this.getHeight(), this.getWidth(), 100);
    }

    public void closeBox() {
        if (this.extension != null) {
            this.getLayer().remove(this.extension);
            this.extension = null;
        }
    }
}

