/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraftforge.api.distmarker.Dist;
import team.creative.creativecore.common.config.gui.GuiConfigControl;
import team.creative.creativecore.common.config.gui.GuiConfigSubControl;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.GuiButton;
import team.creative.creativecore.common.gui.controls.GuiLabel;
import team.creative.creativecore.common.util.text.TextBuilder;

public class GuiConfigSubControlHolder
extends GuiConfigSubControl {
    public final ICreativeConfigHolder holder;
    public final Object value;

    public GuiConfigSubControlHolder(String name, int x, int y, int width, int height, ICreativeConfigHolder holder, Object value) {
        super(name, x, y, width, height);
        this.holder = holder;
        this.value = value;
    }

    public void createControls() {
        int offsetX = 1;
        int offsetY = 1;
        for (ConfigKey configKey : this.holder.fields()) {
            if (configKey.requiresRestart) continue;
            Object value = configKey.get();
            String caption = GuiConfigSubControlHolder.translateOrDefault("config." + String.join((CharSequence)".", this.holder.path()) + "." + configKey.name + ".name", configKey.name);
            String comment = "config." + String.join((CharSequence)".", this.holder.path()) + "." + configKey.name + ".comment";
            if (value instanceof ICreativeConfigHolder) continue;
            GuiLabel label = new GuiLabel(caption + ":", offsetX, offsetY + 2);
            GuiConfigControl config = new GuiConfigControl((ConfigKey.ConfigKeyField)configKey, 0, offsetY, 100, 14, Dist.DEDICATED_SERVER);
            GuiButton resetButton = new GuiButton("r", offsetX + 390, offsetY, x -> config.reset());
            int labelWidth = 40;
            config.setX(label.getX() + labelWidth + 2);
            config.setWidth(this.getWidth() - 25 - config.getX());
            config.init(null);
            this.add(label.setTooltip(new TextBuilder().translateIfCan(comment).build()));
            this.add(config);
            this.add(resetButton.setTooltip(new TextBuilder().text("reset to default").build()));
            config.setResetButton(resetButton);
            offsetY += config.getHeight() + 1;
        }
        this.setHeight(offsetY);
    }

    public void save() {
        JsonObject json = new JsonObject();
        for (GuiControl control : this) {
            JsonElement element;
            if (!(control instanceof GuiConfigControl) || (element = ((GuiConfigControl)control).save()) == null) continue;
            json.add(((GuiConfigControl)control).field.name, element);
        }
        this.holder.load(false, true, json, Dist.DEDICATED_SERVER);
    }
}

