/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.util.ExpandNewLineTextAcceptor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public final class StringUtil {
    private StringUtil() {
    }

    public static ITextComponent stripStyling(ITextComponent textComponent) {
        IFormattableTextComponent text = textComponent.func_230531_f_();
        for (ITextComponent sibling : textComponent.func_150253_a()) {
            text.func_230529_a_(StringUtil.stripStyling(sibling));
        }
        return text;
    }

    public static ITextComponent truncateStringToWidth(ITextComponent text, int width, FontRenderer fontRenderer) {
        int ellipsisWidth = fontRenderer.func_78256_a("...");
        ITextProperties truncatedText = fontRenderer.func_238417_a_((ITextProperties)text, width - ellipsisWidth);
        String truncatedTextString = truncatedText.getString();
        return new StringTextComponent(truncatedTextString + "...");
    }

    public static List<ITextProperties> splitLines(ITextProperties line, int width) {
        if (width <= 0) {
            return Collections.singletonList(line);
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer font = minecraft.field_71466_p;
        CharacterManager splitter = font.func_238420_b_();
        return splitter.func_238362_b_(line, width, Style.field_240709_b_);
    }

    public static List<ITextProperties> splitLines(List<? extends ITextProperties> lines, int width) {
        if (width <= 0) {
            return lines;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer font = minecraft.field_71466_p;
        CharacterManager splitter = font.func_238420_b_();
        return lines.stream().flatMap(text -> splitter.func_238362_b_(text, width, Style.field_240709_b_).stream()).collect(Collectors.toList());
    }

    public static List<ITextProperties> expandNewlines(ITextComponent ... descriptionComponents) {
        ArrayList<ITextProperties> descriptionLinesExpanded = new ArrayList<ITextProperties>();
        for (ITextComponent descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.func_230439_a_((ITextProperties.IStyledTextAcceptor)newLineTextAcceptor, Style.field_240709_b_);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }
}

