/*
 * Decompiled with CFR 0.152.
 */
package oculus.org.anarres.cpp;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import oculus.org.anarres.cpp.BuildMetadata;
import oculus.org.anarres.cpp.DefaultPreprocessorListener;
import oculus.org.anarres.cpp.Feature;
import oculus.org.anarres.cpp.FileLexerSource;
import oculus.org.anarres.cpp.InputLexerSource;
import oculus.org.anarres.cpp.Preprocessor;
import oculus.org.anarres.cpp.Source;
import oculus.org.anarres.cpp.StringLexerSource;
import oculus.org.anarres.cpp.Token;
import oculus.org.anarres.cpp.Warning;
import oculus.org.slf4j.Logger;
import oculus.org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    @Nonnull
    private static CharSequence getWarnings() {
        StringBuilder buf = new StringBuilder();
        for (Warning w : Warning.values()) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            String name = w.name().toLowerCase();
            buf.append(name.replace('_', '-'));
        }
        return buf;
    }

    public static void main(String[] args) throws Exception {
        new Main().run(args);
    }

    public void run(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec helpOption = parser.accepts("help", "Displays command-line help.").forHelp();
        AbstractOptionSpec versionOption = parser.acceptsAll(Arrays.asList("version"), "Displays the product version (" + BuildMetadata.getInstance().getVersion() + ") and exits.").forHelp();
        OptionSpecBuilder debugOption = parser.acceptsAll(Arrays.asList("debug"), "Enables debug output.");
        ArgumentAcceptingOptionSpec defineOption = parser.acceptsAll(Arrays.asList("define", "D"), "Defines the given macro.").withRequiredArg().ofType(String.class).describedAs("name[=definition]");
        ArgumentAcceptingOptionSpec undefineOption = parser.acceptsAll(Arrays.asList("undefine", "U"), "Undefines the given macro, previously either builtin or defined using -D.").withRequiredArg().describedAs("name");
        ArgumentAcceptingOptionSpec includeOption = parser.accepts("include", "Process file as if \"#include \"file\"\" appeared as the first line of the primary source file.").withRequiredArg().ofType(File.class).describedAs("file");
        ArgumentAcceptingOptionSpec incdirOption = parser.acceptsAll(Arrays.asList("incdir", "I"), "Adds the directory dir to the list of directories to be searched for header files.").withRequiredArg().ofType(File.class).describedAs("dir");
        ArgumentAcceptingOptionSpec iquoteOption = parser.acceptsAll(Arrays.asList("iquote"), "Adds the directory dir to the list of directories to be searched for header files included using \"\".").withRequiredArg().ofType(File.class).describedAs("dir");
        ArgumentAcceptingOptionSpec warningOption = parser.acceptsAll(Arrays.asList("warning", "W"), "Enables the named warning class (" + Main.getWarnings() + ").").withRequiredArg().ofType(String.class).describedAs("warning");
        OptionSpecBuilder noWarningOption = parser.acceptsAll(Arrays.asList("no-warnings", "w"), "Disables ALL warnings.");
        NonOptionArgumentSpec inputsOption = parser.nonOptions().ofType(File.class).describedAs("Files to process.");
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpOption)) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        if (options.has((OptionSpec)versionOption)) {
            Main.version(System.out);
            return;
        }
        Preprocessor pp = new Preprocessor();
        pp.addFeature(Feature.DIGRAPHS);
        pp.addFeature(Feature.TRIGRAPHS);
        pp.addFeature(Feature.LINEMARKERS);
        pp.addWarning(Warning.IMPORT);
        pp.setListener(new DefaultPreprocessorListener());
        pp.addMacro("__JCPP__");
        pp.getSystemIncludePath().add("/usr/local/include");
        pp.getSystemIncludePath().add("/usr/include");
        pp.getFrameworksPath().add("/System/Library/Frameworks");
        pp.getFrameworksPath().add("/Library/Frameworks");
        pp.getFrameworksPath().add("/Local/Library/Frameworks");
        if (options.has((OptionSpec)debugOption)) {
            pp.addFeature(Feature.DEBUG);
        }
        if (options.has((OptionSpec)noWarningOption)) {
            pp.getWarnings().clear();
        }
        for (String warning : options.valuesOf((OptionSpec)warningOption)) {
            warning = warning.toUpperCase();
            if ((warning = warning.replace('-', '_')).equals("ALL")) {
                pp.addWarnings(EnumSet.allOf(Warning.class));
                continue;
            }
            pp.addWarning(Enum.valueOf(Warning.class, warning));
        }
        for (String arg : options.valuesOf((OptionSpec)defineOption)) {
            int idx = arg.indexOf(61);
            if (idx == -1) {
                pp.addMacro(arg);
                continue;
            }
            pp.addMacro(arg.substring(0, idx), arg.substring(idx + 1));
        }
        for (String arg : options.valuesOf((OptionSpec)undefineOption)) {
            pp.getMacros().remove(arg);
        }
        for (File dir : options.valuesOf((OptionSpec)incdirOption)) {
            pp.getSystemIncludePath().add(dir.getAbsolutePath());
        }
        for (File dir : options.valuesOf((OptionSpec)iquoteOption)) {
            pp.getQuoteIncludePath().add(dir.getAbsolutePath());
        }
        for (Iterator<String> file : options.valuesOf((OptionSpec)includeOption)) {
            pp.addInput(new StringLexerSource("#include \"" + file + "\"\n"));
        }
        List inputs = options.valuesOf((OptionSpec)inputsOption);
        if (inputs.isEmpty()) {
            pp.addInput(new InputLexerSource(System.in));
        } else {
            for (File input : inputs) {
                pp.addInput(new FileLexerSource(input));
            }
        }
        if (pp.getFeature(Feature.DEBUG)) {
            LOG.info("#include \"...\" search starts here:");
            for (String dir : pp.getQuoteIncludePath()) {
                LOG.info("  " + dir);
            }
            LOG.info("#include <...> search starts here:");
            for (String dir : pp.getSystemIncludePath()) {
                LOG.info("  " + dir);
            }
            LOG.info("End of search list.");
        }
        try {
            Token tok;
            while ((tok = pp.token()) != null && tok.getType() != 265) {
                System.out.print(tok.getText());
            }
        }
        catch (Exception e) {
            StringBuilder buf = new StringBuilder("Preprocessor failed:\n");
            for (Source s = pp.getSource(); s != null; s = s.getParent()) {
                buf.append(" -> ").append(s).append("\n");
            }
            LOG.error(buf.toString(), e);
        }
    }

    private static void version(@Nonnull PrintStream out) {
        BuildMetadata metadata = BuildMetadata.getInstance();
        out.println("Anarres Java C Preprocessor version " + metadata.getVersion() + " change-id " + metadata.getChangeId());
        out.println("Copyright (C) 2007-2015 Shevek (http://www.anarres.org/).");
        out.println("This is free software; see the source for copying conditions.  There is NO");
        out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
    }
}

