/*
 * Decompiled with CFR 0.152.
 */
package oculus.org.anarres.cpp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import oculus.org.anarres.cpp.DefaultPreprocessorListener;
import oculus.org.anarres.cpp.Preprocessor;
import oculus.org.anarres.cpp.Token;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.Path;

public class CppTask
extends Copy {
    private final Listener listener = new Listener();
    private final List<Macro> macros = new ArrayList<Macro>();
    private Path systemincludepath;
    private Path localincludepath;

    public void addMacro(Macro macro) {
        this.macros.add(macro);
    }

    public void addSystemincludepath(Path path) {
        if (this.systemincludepath == null) {
            this.systemincludepath = new Path(this.getProject());
        }
        this.systemincludepath.add(path);
    }

    public void addLocalincludepath(Path path) {
        if (this.localincludepath == null) {
            this.localincludepath = new Path(this.getProject());
        }
        this.localincludepath.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preprocess(File input, File output) throws Exception {
        File dir;
        if (input == null) {
            throw new BuildException("Input not specified");
        }
        if (output == null) {
            throw new BuildException("Output not specified");
        }
        Preprocessor cpp = new Preprocessor();
        cpp.setListener(this.listener);
        for (Macro macro : this.macros) {
            cpp.addMacro(macro.getName(), macro.getValue());
        }
        if (this.systemincludepath != null) {
            cpp.setSystemIncludePath(Arrays.asList(this.systemincludepath.list()));
        }
        if (this.localincludepath != null) {
            cpp.setQuoteIncludePath(Arrays.asList(this.localincludepath.list()));
        }
        if (!(dir = output.getParentFile()).exists()) {
            if (!dir.mkdirs()) {
                throw new BuildException("Failed to make parent directory " + dir);
            }
        } else if (!dir.isDirectory()) {
            throw new BuildException("Parent directory of output file " + output + " exists, but is not a directory.");
        }
        OutputStreamWriter writer = null;
        try {
            Token tok;
            cpp.addInput(input);
            writer = new FileWriter(output);
            while ((tok = cpp.token()) != null) {
                if (tok.getType() == 265) {
                    break;
                }
                writer.write(tok.getText());
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void doFileOperations() {
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Enumeration e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String[] toFiles;
                String fromFile = (String)e.nextElement();
                for (String toFile : toFiles = (String[])this.fileCopyMap.get(fromFile)) {
                    if (fromFile.equals(toFile)) {
                        this.log("Skipping self-copy of " + fromFile, this.verbosity);
                        continue;
                    }
                    try {
                        this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
                        File srcFile = new File(fromFile);
                        File dstFile = new File(toFile);
                        this.preprocess(srcFile, dstFile);
                    }
                    catch (Exception ioe) {
                        String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        throw new BuildException(msg, (Throwable)ioe, this.getLocation());
                    }
                }
            }
        }
    }

    public static class Macro {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private class Listener
    extends DefaultPreprocessorListener {
        private Listener() {
        }

        protected void print(String msg) {
            CppTask.this.log(msg);
        }
    }
}

