/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows.frustum.advanced;

import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.advanced.BaseClippingPlanes;
import net.coderbot.iris.shadows.frustum.advanced.NeighboringPlaneSet;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Matrix4f;

public class AdvancedShadowCullingFrustum
extends ClippingHelper {
    private static final int MAX_CLIPPING_PLANES = 13;
    private final Vector4f[] planes = new Vector4f[13];
    private int planeCount = 0;
    private double x;
    private double y;
    private double z;
    private final Vector3f shadowLightVectorFromOrigin;
    private final BoxCuller boxCuller;

    public AdvancedShadowCullingFrustum(net.coderbot.iris.vendored.joml.Matrix4f playerView, net.coderbot.iris.vendored.joml.Matrix4f playerProjection, Vector3f shadowLightVectorFromOrigin, BoxCuller boxCuller) {
        super(new Matrix4f(), new Matrix4f());
        this.shadowLightVectorFromOrigin = shadowLightVectorFromOrigin;
        BaseClippingPlanes baseClippingPlanes = new BaseClippingPlanes(playerView, playerProjection);
        boolean[] isBack = this.addBackPlanes(baseClippingPlanes);
        this.addEdgePlanes(baseClippingPlanes, isBack);
        this.boxCuller = boxCuller;
    }

    private void addPlane(Vector4f plane) {
        this.planes[this.planeCount] = plane;
        ++this.planeCount;
    }

    private boolean[] addBackPlanes(BaseClippingPlanes baseClippingPlanes) {
        Vector4f[] planes = baseClippingPlanes.getPlanes();
        boolean[] isBack = new boolean[planes.length];
        for (int planeIndex = 0; planeIndex < planes.length; ++planeIndex) {
            Vector4f plane = planes[planeIndex];
            Vector3f planeNormal = this.truncate(plane);
            float dot = planeNormal.dot(this.shadowLightVectorFromOrigin);
            boolean back = (double)dot > 0.0;
            boolean edge = (double)dot == 0.0;
            isBack[planeIndex] = back;
            if (!back && !edge) continue;
            this.addPlane(plane);
        }
        return isBack;
    }

    private void addEdgePlanes(BaseClippingPlanes baseClippingPlanes, boolean[] isBack) {
        Vector4f[] planes = baseClippingPlanes.getPlanes();
        for (int planeIndex = 0; planeIndex < planes.length; ++planeIndex) {
            if (!isBack[planeIndex]) continue;
            Vector4f plane = planes[planeIndex];
            NeighboringPlaneSet neighbors = NeighboringPlaneSet.forPlane(planeIndex);
            if (!isBack[neighbors.getPlane0()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane0()]);
            }
            if (!isBack[neighbors.getPlane1()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane1()]);
            }
            if (!isBack[neighbors.getPlane2()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane2()]);
            }
            if (isBack[neighbors.getPlane3()]) continue;
            this.addEdgePlane(plane, planes[neighbors.getPlane3()]);
        }
    }

    private Vector3f truncate(Vector4f base) {
        return new Vector3f(base.x(), base.y(), base.z());
    }

    private Vector4f extend(Vector3f base, float w) {
        return new Vector4f(base.x(), base.y(), base.z(), w);
    }

    private float lengthSquared(Vector3f v) {
        float x = v.x();
        float y = v.y();
        float z = v.z();
        return x * x + y * y + z * z;
    }

    private Vector3f cross(Vector3f first, Vector3f second) {
        Vector3f result = new Vector3f(first.x(), first.y(), first.z());
        result.cross(second);
        return result;
    }

    private void addEdgePlane(Vector4f backPlane4, Vector4f frontPlane4) {
        Vector3f backPlaneNormal = this.truncate(backPlane4);
        Vector3f frontPlaneNormal = this.truncate(frontPlane4);
        Vector3f intersection = this.cross(backPlaneNormal, frontPlaneNormal);
        Vector3f edgePlaneNormal = this.cross(intersection, this.shadowLightVectorFromOrigin);
        Vector3f ixb = this.cross(intersection, backPlaneNormal);
        Vector3f fxi = this.cross(frontPlaneNormal, intersection);
        ixb.mul(-frontPlane4.w());
        fxi.mul(-backPlane4.w());
        ixb.add(fxi);
        Vector3f point = ixb;
        point.mul(1.0f / this.lengthSquared(intersection));
        float d = edgePlaneNormal.dot(point);
        float w = -d;
        Vector4f plane = this.extend(edgePlaneNormal, w);
        this.addPlane(plane);
    }

    public void func_228952_a_(double cameraX, double cameraY, double cameraZ) {
        if (this.boxCuller != null) {
            this.boxCuller.setPosition(cameraX, cameraY, cameraZ);
        }
        this.x = cameraX;
        this.y = cameraY;
        this.z = cameraZ;
    }

    public boolean func_228957_a_(AxisAlignedBB aabb) {
        if (this.boxCuller != null && this.boxCuller.isCulled(aabb)) {
            return false;
        }
        return this.isVisible(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public boolean fastAabbTest(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (this.boxCuller != null && this.boxCuller.isCulled(minX, minY, minZ, maxX, maxY, maxZ)) {
            return false;
        }
        return this.isVisible(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean canDetermineInvisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return false;
    }

    private boolean isVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        float f = (float)(minX - this.x);
        float g = (float)(minY - this.y);
        float h = (float)(minZ - this.z);
        float i = (float)(maxX - this.x);
        float j = (float)(maxY - this.y);
        float k = (float)(maxZ - this.z);
        return this.checkCornerVisibility(f, g, h, i, j, k) != 0;
    }

    private int checkCornerVisibility(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        boolean inside = true;
        for (int i = 0; i < this.planeCount; ++i) {
            float insideBoundZ;
            float outsideBoundZ;
            float insideBoundY;
            float outsideBoundY;
            float insideBoundX;
            float outsideBoundX;
            Vector4f plane = this.planes[i];
            if (plane.x() < 0.0f) {
                outsideBoundX = minX;
                insideBoundX = maxX;
            } else {
                outsideBoundX = maxX;
                insideBoundX = minX;
            }
            if (plane.y() < 0.0f) {
                outsideBoundY = minY;
                insideBoundY = maxY;
            } else {
                outsideBoundY = maxY;
                insideBoundY = minY;
            }
            if (plane.z() < 0.0f) {
                outsideBoundZ = minZ;
                insideBoundZ = maxZ;
            } else {
                outsideBoundZ = maxZ;
                insideBoundZ = minZ;
            }
            if (Math.fma(plane.x(), outsideBoundX, Math.fma(plane.y(), outsideBoundY, plane.z() * outsideBoundZ)) < -plane.w()) {
                return 0;
            }
            inside &= Math.fma(plane.x(), insideBoundX, Math.fma(plane.y(), insideBoundY, plane.z() * insideBoundZ)) >= -plane.w();
        }
        return 2;
    }
}

