/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadow;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class ShadowMatrices {
    private static final float NEAR = 0.05f;
    private static final float FAR = 256.0f;

    public static float[] createOrthoMatrix(float halfPlaneLength) {
        return new float[]{1.0f / halfPlaneLength, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / halfPlaneLength, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f};
    }

    public static float[] createPerspectiveMatrix(float fov) {
        float yScale = (float)(1.0 / Math.tan(Math.toRadians(fov) * 0.5));
        return new float[]{yScale, 0.0f, 0.0f, 0.0f, 0.0f, yScale, 0.0f, 0.0f, 0.0f, 0.0f, -1.0003906f, -1.0f, 0.0f, 0.0f, -0.10001954f, 1.0f};
    }

    public static void createBaselineModelViewMatrix(MatrixStack target, float shadowAngle, float sunPathRotation) {
        float skyAngle = shadowAngle < 0.25f ? shadowAngle + 0.75f : shadowAngle - 0.25f;
        target.func_227866_c_().func_227872_b_().func_226119_c_();
        target.func_227866_c_().func_227870_a_().func_226591_a_();
        target.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_226599_b_((float)0.0f, (float)0.0f, (float)-100.0f));
        target.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        target.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(skyAngle * -360.0f));
        target.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(sunPathRotation));
    }

    public static void snapModelViewToGrid(MatrixStack target, float shadowIntervalSize, double cameraX, double cameraY, double cameraZ) {
        if (Math.abs(shadowIntervalSize) == 0.0f) {
            return;
        }
        float offsetX = (float)cameraX % shadowIntervalSize;
        float offsetY = (float)cameraY % shadowIntervalSize;
        float offsetZ = (float)cameraZ % shadowIntervalSize;
        float halfIntervalSize = shadowIntervalSize / 2.0f;
        target.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_226599_b_((float)(offsetX -= halfIntervalSize), (float)(offsetY -= halfIntervalSize), (float)(offsetZ -= halfIntervalSize)));
    }

    public static void createModelViewMatrix(MatrixStack target, float shadowAngle, float shadowIntervalSize, float sunPathRotation, double cameraX, double cameraY, double cameraZ) {
        ShadowMatrices.createBaselineModelViewMatrix(target, shadowAngle, sunPathRotation);
        ShadowMatrices.snapModelViewToGrid(target, shadowIntervalSize, cameraX, cameraY, cameraZ);
    }

    private static final class Tests {
        private Tests() {
        }

        public static void main(String[] args) {
            float[] expected = new float[]{0.03125f, 0.0f, 0.0f, 0.0f, 0.0f, 0.03125f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f};
            Tests.test("ortho projection hpl=32", expected, ShadowMatrices.createOrthoMatrix(32.0f));
            float[] expected110 = new float[]{0.009090909f, 0.0f, 0.0f, 0.0f, 0.0f, 0.009090909f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f};
            Tests.test("ortho projection hpl=110", expected110, ShadowMatrices.createOrthoMatrix(110.0f));
            float[] expected90Proj = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0003906f, -1.0f, 0.0f, 0.0f, -0.10001954f, 0.0f};
            Tests.test("perspective projection fov=90", expected90Proj, ShadowMatrices.createPerspectiveMatrix(90.0f));
            float[] expectedModelViewAtDawn = new float[]{0.2154504f, 5.8204815E-8f, 0.9765147f, 0.0f, -0.97651476f, 1.2841845E-8f, 0.21545039f, 0.0f, 0.0f, -0.99999994f, 5.9604645E-8f, 0.0f, 0.3800215f, 1.0264281f, -100.44631f, 1.0f};
            MatrixStack modelView = new MatrixStack();
            ShadowMatrices.createModelViewMatrix(modelView, 0.03451777f, 2.0f, 0.0f, 0.646045982837677, 82.53274536132812, -514.0264282226562);
            Tests.test("model view at dawn", expectedModelViewAtDawn, Tests.toFloatArray(modelView.func_227866_c_().func_227870_a_()));
        }

        private static float[] toFloatArray(Matrix4f matrix4f) {
            FloatBuffer buffer = FloatBuffer.allocate(16);
            matrix4f.func_195879_b(buffer);
            return buffer.array();
        }

        private static void test(String name, float[] expected, float[] created) {
            if (!Tests.areMatricesEqualWithinEpsilon(expected, created)) {
                System.err.println("test " + name + " failed: ");
                System.err.println("    expected: ");
                System.err.print(Tests.printMatrix(expected, 8));
                System.err.println("    created: ");
                System.err.print(Tests.printMatrix(created, 8));
            } else {
                System.out.println("test " + name + " passed");
            }
        }

        private static boolean areMatricesEqualWithinEpsilon(float[] expected, float[] created) {
            for (int i = 0; i < 16; ++i) {
                if (!(Math.abs(expected[i] - created[i]) > 5.0E-4f)) continue;
                return false;
            }
            return true;
        }

        private static String printMatrix(float[] matrix, int spaces) {
            StringBuilder lines = new StringBuilder();
            for (int row = 0; row < 4; ++row) {
                for (int i = 0; i < spaces; ++i) {
                    lines.append(' ');
                }
                lines.append('[');
                for (int column = 0; column < 4; ++column) {
                    lines.append(' ');
                    lines.append(matrix[column * 4 + row]);
                }
                lines.append(" ]");
                lines.append('\n');
            }
            return lines.toString();
        }
    }
}

