/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.vertices;

import com.mojang.blaze3d.vertex.IVertexConsumer;
import java.nio.ByteBuffer;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.BlockSensitiveBufferBuilder;
import net.coderbot.iris.vertices.BufferBuilderPolygonView;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.ExtendingBufferBuilder;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BufferBuilder.class})
public abstract class MixinBufferBuilder
implements IVertexConsumer,
BlockSensitiveBufferBuilder,
ExtendingBufferBuilder {
    @Unique
    private boolean extending;
    @Unique
    private boolean iris$shouldNotExtend = false;
    @Unique
    private boolean iris$isTerrain = false;
    @Unique
    private int vertexCount;
    @Unique
    private final BufferBuilderPolygonView polygon = new BufferBuilderPolygonView();
    @Unique
    private final Vector3f normal = new Vector3f();
    @Unique
    private boolean injectNormal;
    @Unique
    private short currentBlock;
    @Unique
    private short currentRenderType;
    @Unique
    private int currentLocalPosX;
    @Unique
    private int currentLocalPosY;
    @Unique
    private int currentLocalPosZ;
    @Shadow
    private boolean field_227826_s_;
    @Shadow
    private boolean field_227827_t_;
    @Shadow
    private ByteBuffer field_179001_a;
    @Shadow
    private int field_179006_k;
    @Shadow
    private VertexFormat field_179011_q;
    @Shadow
    private int field_227824_l_;
    @Shadow
    @Nullable
    private VertexFormatElement field_181677_f;

    @Shadow
    public abstract void func_181668_a(int var1, VertexFormat var2);

    @Shadow
    public abstract void func_225591_a_(int var1, short var2);

    @Shadow
    protected abstract void func_227828_a_(VertexFormat var1);

    @Shadow
    protected abstract void func_181670_b(int var1);

    @Override
    public void iris$beginWithoutExtending(int drawMode, VertexFormat vertexFormat) {
        this.iris$shouldNotExtend = true;
        this.func_181668_a(drawMode, vertexFormat);
        this.iris$shouldNotExtend = false;
    }

    @Inject(method={"begin"}, at={@At(value="HEAD")})
    private void iris$onBegin(int drawMode, VertexFormat format, CallbackInfo ci) {
        boolean shouldExtend = !this.iris$shouldNotExtend && BlockRenderingSettings.INSTANCE.shouldUseExtendedVertexFormat();
        this.extending = shouldExtend && (format == DefaultVertexFormats.field_176600_a || format == DefaultVertexFormats.field_227849_i_ || format == DefaultVertexFormats.field_227852_q_);
        this.vertexCount = 0;
        if (this.extending) {
            this.injectNormal = format == DefaultVertexFormats.field_227852_q_;
        }
    }

    @Inject(method={"begin"}, at={@At(value="RETURN")})
    private void iris$afterBegin(int drawMode, VertexFormat format, CallbackInfo ci) {
        if (this.extending) {
            if (format == DefaultVertexFormats.field_227849_i_) {
                this.func_227828_a_(IrisVertexFormats.ENTITY);
                this.iris$isTerrain = false;
            } else {
                this.func_227828_a_(IrisVertexFormats.TERRAIN);
                this.iris$isTerrain = true;
            }
            this.field_181677_f = (VertexFormatElement)this.field_179011_q.func_227894_c_().get(0);
        }
    }

    @Inject(method={"discard"}, at={@At(value="HEAD")})
    private void iris$onReset(CallbackInfo ci) {
        this.extending = false;
        this.vertexCount = 0;
    }

    @Inject(method={"switchFormat"}, at={@At(value="RETURN")})
    private void iris$preventHardcodedVertexWriting(VertexFormat format, CallbackInfo ci) {
        if (!this.extending) {
            return;
        }
        this.field_227826_s_ = false;
        this.field_227827_t_ = false;
    }

    @Inject(method={"endVertex"}, at={@At(value="HEAD")})
    private void iris$beforeNext(CallbackInfo ci) {
        if (!this.extending) {
            return;
        }
        if (this.injectNormal && this.field_181677_f == DefaultVertexFormats.field_181717_q) {
            this.putInt(0, 0);
            this.func_181667_k();
        }
        this.func_181670_b(15);
        if (this.iris$isTerrain) {
            this.func_225591_a_(0, this.currentBlock);
            this.func_225591_a_(2, this.currentRenderType);
            this.func_181667_k();
        }
        this.func_225590_a_(0, 0.0f);
        this.func_225590_a_(4, 0.0f);
        this.func_181667_k();
        this.putInt(0, 0);
        this.func_181667_k();
        if (this.iris$isTerrain) {
            int posIndex = this.field_227824_l_ - 48;
            float x = this.field_179001_a.getFloat(posIndex);
            float y = this.field_179001_a.getFloat(posIndex + 4);
            float z = this.field_179001_a.getFloat(posIndex + 8);
            this.putInt(0, ExtendedDataHelper.computeMidBlock(x, y, z, this.currentLocalPosX, this.currentLocalPosY, this.currentLocalPosZ));
            this.func_181667_k();
        }
        ++this.vertexCount;
        if (this.field_179006_k == 7 && this.vertexCount == 4 || this.field_179006_k == 4 && this.vertexCount == 3) {
            this.fillExtendedData(this.vertexCount);
        }
    }

    @Unique
    private void fillExtendedData(int vertexAmount) {
        int tangentOffset;
        int normalOffset;
        int midVOffset;
        int midUOffset;
        this.vertexCount = 0;
        int stride = this.field_179011_q.func_177338_f();
        this.polygon.setup(this.field_179001_a, this.field_227824_l_, stride, vertexAmount);
        float midU = 0.0f;
        float midV = 0.0f;
        for (int vertex = 0; vertex < vertexAmount; ++vertex) {
            midU += this.polygon.u(vertex);
            midV += this.polygon.v(vertex);
        }
        midU /= (float)vertexAmount;
        midV /= (float)vertexAmount;
        if (this.iris$isTerrain) {
            midUOffset = 16;
            midVOffset = 12;
            normalOffset = 24;
            tangentOffset = 8;
        } else {
            midUOffset = 12;
            midVOffset = 8;
            normalOffset = 16;
            tangentOffset = 4;
        }
        if (vertexAmount == 3) {
            for (int vertex = 0; vertex < vertexAmount; ++vertex) {
                int packedNormal = this.field_179001_a.getInt(this.field_227824_l_ - normalOffset - stride * vertex);
                int tangent = NormalHelper.computeTangentSmooth(NormI8.unpackX(packedNormal), NormI8.unpackY(packedNormal), NormI8.unpackZ(packedNormal), this.polygon);
                this.field_179001_a.putFloat(this.field_227824_l_ - midUOffset - stride * vertex, midU);
                this.field_179001_a.putFloat(this.field_227824_l_ - midVOffset - stride * vertex, midV);
                this.field_179001_a.putInt(this.field_227824_l_ - tangentOffset - stride * vertex, tangent);
            }
        } else {
            NormalHelper.computeFaceNormal(this.normal, this.polygon);
            int packedNormal = NormI8.pack(this.normal.x, this.normal.y, this.normal.z, 0.0f);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.polygon);
            for (int vertex = 0; vertex < vertexAmount; ++vertex) {
                this.field_179001_a.putFloat(this.field_227824_l_ - midUOffset - stride * vertex, midU);
                this.field_179001_a.putFloat(this.field_227824_l_ - midVOffset - stride * vertex, midV);
                this.field_179001_a.putInt(this.field_227824_l_ - normalOffset - stride * vertex, packedNormal);
                this.field_179001_a.putInt(this.field_227824_l_ - tangentOffset - stride * vertex, tangent);
            }
        }
    }

    @Override
    public void beginBlock(short block, short renderType, int localPosX, int localPosY, int localPosZ) {
        this.currentBlock = block;
        this.currentRenderType = renderType;
        this.currentLocalPosX = localPosX;
        this.currentLocalPosY = localPosY;
        this.currentLocalPosZ = localPosZ;
    }

    @Override
    public void endBlock() {
        this.currentBlock = (short)-1;
        this.currentRenderType = (short)-1;
        this.currentLocalPosX = 0;
        this.currentLocalPosY = 0;
        this.currentLocalPosZ = 0;
    }

    @Unique
    private void putInt(int i, int value) {
        this.field_179001_a.putInt(this.field_227824_l_ + i, value);
    }
}

