/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.bettermipmaps;

import java.util.Locale;
import java.util.Objects;
import net.coderbot.iris.helpers.ColorSRGB;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={TextureAtlasSprite.class})
public class MixinTextureAtlasSprite {
    private static final float[] SRGB_TO_LINEAR = new float[256];
    @Shadow
    @Final
    private TextureAtlasSprite.Info field_229226_c_;

    @ModifyVariable(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;metadata:Lnet/minecraft/client/resources/metadata/animation/AnimationMetadataSection;"), argsOnly=true)
    private NativeImage iris$beforeGenerateMipLevels(NativeImage nativeImage) {
        ResourceLocation name = Objects.requireNonNull(this.field_229226_c_).func_229248_a_();
        if (name.func_110623_a().contains("leaves")) {
            return nativeImage;
        }
        MixinTextureAtlasSprite.iris$fillInTransparentPixelColors(nativeImage);
        return nativeImage;
    }

    @Unique
    private static void iris$fillInTransparentPixelColors(NativeImage nativeImage) {
        long ppPixel = MixinTextureAtlasSprite.getPointerRGBA(nativeImage);
        int pixelCount = nativeImage.func_195714_b() * nativeImage.func_195702_a();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalWeight = 0.0f;
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = NativeImage.func_227786_a_((int)color);
            if (alpha == 0) continue;
            float weight = alpha;
            r += ColorSRGB.srgbToLinear(NativeImage.func_227791_b_((int)color)) * weight;
            g += ColorSRGB.srgbToLinear(NativeImage.func_227793_c_((int)color)) * weight;
            b += ColorSRGB.srgbToLinear(NativeImage.func_227795_d_((int)color)) * weight;
            totalWeight += weight;
        }
        if (totalWeight == 0.0f) {
            return;
        }
        int averageColor = ColorSRGB.linearToSrgb(r /= totalWeight, g /= totalWeight, b /= totalWeight, 0);
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = NativeImage.func_227786_a_((int)color);
            if (alpha != 0) continue;
            MemoryUtil.memPutInt((long)pPixel, (int)averageColor);
        }
    }

    private static long getPointerRGBA(NativeImage nativeImage) {
        if (nativeImage.func_211678_c() != NativeImage.PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Tried to get pointer to RGBA pixel data on NativeImage of wrong format; have %s", nativeImage.func_211678_c()));
        }
        return nativeImage.field_195722_d;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MixinTextureAtlasSprite.SRGB_TO_LINEAR[i] = (float)Math.pow((double)i / 255.0, 2.2);
        }
    }
}

