/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.separate_ao;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.DefaultColorVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.type.VertexType;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorU8;
import me.jellysquid.mods.sodium.client.util.math.MatrixUtil;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BufferBuilder.class}, priority=1010)
public abstract class MixinBufferBuilder_IntrinsicSeparateAo
extends DefaultColorVertexBuilder {
    @Shadow
    private boolean field_227826_s_;

    public void func_227890_a_(MatrixStack.Entry matrixEntry, BakedQuad quad, float[] brightnesses, float red, float green, float blue, int[] lights, int overlay, boolean useQuadColorData) {
        if (!this.field_227826_s_) {
            if (BlockRenderingSettings.INSTANCE.shouldUseSeparateAo()) {
                brightnesses = new float[brightnesses.length];
                Arrays.fill(brightnesses, 1.0f);
            }
            super.func_227890_a_(matrixEntry, quad, brightnesses, red, green, blue, lights, overlay, useQuadColorData);
            return;
        }
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        ModelQuadView quadView = (ModelQuadView)quad;
        Matrix4f positionMatrix = matrixEntry.func_227870_a_();
        Matrix3f normalMatrix = matrixEntry.func_227872_b_();
        int norm = MatrixUtil.computeNormal((Matrix3f)normalMatrix, (Direction)quad.func_178210_d());
        QuadVertexSink drain = (QuadVertexSink)VertexDrain.of((IVertexBuilder)this).createSink((VertexType)VanillaVertexTypes.QUADS);
        drain.ensureCapacity(4);
        for (int i = 0; i < 4; ++i) {
            float fB;
            float fG;
            float fR;
            float oR;
            float x = quadView.getX(i);
            float y = quadView.getY(i);
            float z = quadView.getZ(i);
            float brightness = brightnesses[i];
            float alpha = 1.0f;
            if (BlockRenderingSettings.INSTANCE.shouldUseSeparateAo()) {
                alpha = brightness;
                if (useQuadColorData) {
                    int color = quadView.getColor(i);
                    oR = ColorU8.normalize((float)ColorABGR.unpackRed((int)color));
                    float oG = ColorU8.normalize((float)ColorABGR.unpackGreen((int)color));
                    float oB = ColorU8.normalize((float)ColorABGR.unpackBlue((int)color));
                    fR = oR * red;
                    fG = oG * green;
                    fB = oB * blue;
                } else {
                    fR = red;
                    fG = green;
                    fB = blue;
                }
            } else if (useQuadColorData) {
                int color = quadView.getColor(i);
                oR = ColorU8.normalize((float)ColorABGR.unpackRed((int)color));
                float oG = ColorU8.normalize((float)ColorABGR.unpackGreen((int)color));
                float oB = ColorU8.normalize((float)ColorABGR.unpackBlue((int)color));
                fR = oR * brightness * red;
                fG = oG * brightness * green;
                fB = oB * brightness * blue;
            } else {
                fR = brightness * red;
                fG = brightness * green;
                fB = brightness * blue;
            }
            float u = quadView.getTexU(i);
            float v = quadView.getTexV(i);
            int color = ColorABGR.pack((float)fR, (float)fG, (float)fB, (float)alpha);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            pos.func_229372_a_(positionMatrix);
            drain.writeQuad(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), color, u, v, lights[i], overlay, norm);
        }
        drain.flush();
    }
}

