/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexUtil;
import net.coderbot.iris.compat.sodium.impl.block_context.BlockContextHolder;
import net.coderbot.iris.compat.sodium.impl.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormalHelper;
import org.lwjgl.system.MemoryUtil;

public class XHFPModelVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements ModelVertexSink,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterUnsafe(VertexBufferView backingBuffer) {
        super(backingBuffer, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    public void writeQuad(float x, float y, float z, int color, float u, float v, int light) {
        this.uSum += u;
        this.vSum += v;
        this.writeQuadInternal(ModelVertexUtil.denormalizeVertexPositionFloatAsShort((float)x), ModelVertexUtil.denormalizeVertexPositionFloatAsShort((float)y), ModelVertexUtil.denormalizeVertexPositionFloatAsShort((float)z), color, ModelVertexUtil.denormalizeVertexTextureFloatAsShort((float)u), ModelVertexUtil.denormalizeVertexTextureFloatAsShort((float)v), light, this.contextHolder.blockId, this.contextHolder.renderType, ExtendedDataHelper.computeMidBlock(x, y, z, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ));
    }

    private void writeQuadInternal(short x, short y, short z, int color, short u, short v, int light, short materialId, short renderType, int packedMidBlock) {
        long i = this.writePointer;
        ++this.vertexCount;
        MemoryUtil.memPutShort((long)i, (short)x);
        MemoryUtil.memPutShort((long)(i + 2L), (short)y);
        MemoryUtil.memPutShort((long)(i + 4L), (short)z);
        MemoryUtil.memPutInt((long)(i + 8L), (int)color);
        MemoryUtil.memPutShort((long)(i + 12L), (short)u);
        MemoryUtil.memPutShort((long)(i + 14L), (short)v);
        MemoryUtil.memPutShort((long)(i + 16L), (short)((short)(light & 0xFFFF)));
        MemoryUtil.memPutShort((long)(i + 18L), (short)((short)(light >> 16 & 0xFFFF)));
        MemoryUtil.memPutShort((long)(i + 36L), (short)materialId);
        MemoryUtil.memPutShort((long)(i + 38L), (short)renderType);
        MemoryUtil.memPutInt((long)(i + 40L), (int)packedMidBlock);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            MemoryUtil.memPutFloat((long)(i + 20L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(i + 20L - 44L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(i + 20L - 88L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(i + 20L - 132L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(i + 24L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(i + 24L - 44L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(i + 24L - 88L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(i + 24L - 132L), (float)this.vSum);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(i, 44);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
            MemoryUtil.memPutInt((long)(i + 32L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(i + 32L - 44L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(i + 32L - 88L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(i + 32L - 132L), (int)packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtil.memPutInt((long)(i + 28L), (int)tangent);
            MemoryUtil.memPutInt((long)(i + 28L - 44L), (int)tangent);
            MemoryUtil.memPutInt((long)(i + 28L - 88L), (int)tangent);
            MemoryUtil.memPutInt((long)(i + 28L - 132L), (int)tangent);
        }
        this.advance();
    }

    @Override
    public void iris$setContextHolder(BlockContextHolder holder) {
        this.contextHolder = holder;
    }
}

