/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.impl;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.coderbot.batchedentityrendering.impl.BufferBuilderExt;
import net.coderbot.batchedentityrendering.impl.BufferSegment;
import net.coderbot.batchedentityrendering.impl.MemoryTrackingBuffer;
import net.coderbot.batchedentityrendering.impl.RenderTypeUtil;
import net.coderbot.batchedentityrendering.mixin.RenderTypeAccessor;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;

public class SegmentedBufferBuilder
implements IRenderTypeBuffer,
MemoryTrackingBuffer {
    private final BufferBuilder buffer = new BufferBuilder(524288);
    private final List<RenderType> usedTypes = new ArrayList<RenderType>(256);
    private RenderType currentType = null;

    public IVertexBuilder getBuffer(RenderType renderType) {
        if (!Objects.equals(this.currentType, renderType)) {
            if (this.currentType != null) {
                if (SegmentedBufferBuilder.shouldSortOnUpload(this.currentType)) {
                    this.buffer.func_181674_a(0.0f, 0.0f, 0.0f);
                }
                this.buffer.func_178977_d();
                this.usedTypes.add(this.currentType);
            }
            this.buffer.func_181668_a(renderType.func_228664_q_(), renderType.func_228663_p_());
            this.currentType = renderType;
        }
        if (RenderTypeUtil.isTriangleStripDrawMode(this.currentType)) {
            ((BufferBuilderExt)this.buffer).splitStrip();
        }
        return this.buffer;
    }

    public List<BufferSegment> getSegments() {
        if (this.currentType == null) {
            return Collections.emptyList();
        }
        this.usedTypes.add(this.currentType);
        if (SegmentedBufferBuilder.shouldSortOnUpload(this.currentType)) {
            this.buffer.func_181674_a(0.0f, 0.0f, 0.0f);
        }
        this.buffer.func_178977_d();
        this.currentType = null;
        ArrayList<BufferSegment> segments = new ArrayList<BufferSegment>(this.usedTypes.size());
        for (RenderType type : this.usedTypes) {
            Pair pair = this.buffer.func_227832_f_();
            BufferBuilder.DrawState drawState = (BufferBuilder.DrawState)pair.getFirst();
            ByteBuffer slice = (ByteBuffer)pair.getSecond();
            segments.add(new BufferSegment(slice, drawState, type));
        }
        this.usedTypes.clear();
        return segments;
    }

    private static boolean shouldSortOnUpload(RenderType type) {
        return ((RenderTypeAccessor)type).shouldSortOnUpload();
    }

    @Override
    public int getAllocatedSize() {
        return ((MemoryTrackingBuffer)this.buffer).getAllocatedSize();
    }

    @Override
    public int getUsedSize() {
        return ((MemoryTrackingBuffer)this.buffer).getUsedSize();
    }
}

