/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query.index;

import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.query.index.Index;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class NodeIndex
implements Index<ASTNode> {
    public final Map<Class<ASTNode>, Set<ASTNode>> index = new HashMap<Class<ASTNode>, Set<ASTNode>>();
    public final Supplier<Set<ASTNode>> bucketConstructor;

    public NodeIndex(Supplier<Set<ASTNode>> bucketConstructor) {
        this.bucketConstructor = bucketConstructor;
    }

    public NodeIndex() {
        this(HashSet::new);
    }

    public static NodeIndex withHashSetBuckets() {
        return new NodeIndex(HashSet::new);
    }

    public static NodeIndex withLinkedHashSetBuckets() {
        return new NodeIndex(LinkedHashSet::new);
    }

    @Override
    public void add(ASTNode node) {
        Class<?> nodeClass = node.getClass();
        Set<ASTNode> set = this.index.get(nodeClass);
        if (set == null) {
            set = this.bucketConstructor.get();
            this.index.put(nodeClass, set);
        }
        set.add(node);
    }

    @Override
    public void remove(ASTNode node) {
        Set<ASTNode> set = this.index.get(node.getClass());
        if (set == null) {
            return;
        }
        set.remove(node);
    }

    public <T extends ASTNode> Set<T> get(Class<T> type) {
        Set<ASTNode> result = this.index.get(type);
        return result == null ? Collections.emptySet() : result;
    }

    public <T extends ASTNode> Stream<T> getStream(Class<T> type) {
        Set<ASTNode> result = this.index.get(type);
        return result == null ? Stream.empty() : result.stream();
    }

    public <T extends ASTNode> T getOne(Class<T> type) {
        Set<ASTNode> result = this.index.get(type);
        if (result == null) {
            return null;
        }
        Iterator<ASTNode> iterator = result.iterator();
        return (T)(iterator.hasNext() ? iterator.next() : null);
    }

    public boolean has(Class<? extends ASTNode> type) {
        Set<ASTNode> result = this.index.get(type);
        return result != null && !result.isEmpty();
    }

    public <T extends ASTNode> Set<T> get(T node) {
        return this.get((T)((Object)node.getClass()));
    }

    public <T extends ASTNode> T getOne(T node) {
        return (T)this.getOne((T)((Object)node.getClass()));
    }

    public boolean has(ASTNode node) {
        return this.has(node.getClass());
    }

    public boolean hasExact(ASTNode node) {
        Set<ASTNode> set = this.get(node);
        return set != null && set.contains(node);
    }
}

