/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class DirectionUtils {
    public static RayTraceResult getPlayerRayTrace(World world, PlayerEntity player, float blockReach) {
        Vector3d eyepos = player.func_174824_e(1.0f);
        Vector3d lookangle = player.func_70040_Z();
        Vector3d lastVec = eyepos.func_178787_e(lookangle);
        Vector3d rayend = eyepos.func_72441_c(lookangle.field_72450_a * (double)blockReach, lookangle.field_72448_b * (double)blockReach, lookangle.field_72449_c * (double)blockReach);
        RayTraceContext context = new RayTraceContext(eyepos, rayend, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null);
        BlockRayTraceResult blockRay = world.func_217299_a(context);
        int x = 0;
        while ((float)x < 16.0f * blockReach) {
            float reach = (float)x / 16.0f;
            Vector3d vec = eyepos.func_72441_c(lookangle.field_72450_a * (double)reach, lookangle.field_72448_b * (double)reach, lookangle.field_72449_c * (double)reach);
            if (blockRay == null || blockRay.func_216347_e() == null) {
                return new BlockRayTraceResult(lookangle, DirectionUtils.getFacing(lookangle), null, false);
            }
            if (blockRay.func_216347_e().func_72438_d(eyepos) < vec.func_72438_d(eyepos)) break;
            AxisAlignedBB AABB = new AxisAlignedBB(lastVec.field_72450_a, lastVec.field_72448_b, lastVec.field_72449_c, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            List entities = world.func_72839_b((Entity)player, AABB);
            if (!entities.isEmpty()) {
                return new EntityRayTraceResult((Entity)entities.get(0), lookangle);
            }
            lastVec = vec;
            ++x;
        }
        return blockRay;
    }

    private static Vector3d getPosVecForEntity(Entity entity) {
        return new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    public static Direction getFacing(Vector3d vec) {
        return Direction.func_210769_a((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c);
    }

    public static Direction getRandomDirectionXZ(Random rand) {
        return DirectionUtils.getXZDirection(rand.nextInt(4));
    }

    public static Direction getXZDirection(int direction) {
        switch (direction) {
            case 1: {
                return Direction.SOUTH;
            }
            case 2: {
                return Direction.EAST;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public static int getXZMeta(Direction facing) {
        if (facing == Direction.UP || facing == Direction.DOWN) {
            return facing.ordinal() + 4;
        }
        return facing.ordinal() - 2;
    }

    public static Vector3d getDirectionVecXZ(Vector3i startpos, Vector3i endpos) {
        return DirectionUtils.getDirectionVecXZ(new Vector3d((double)startpos.func_177958_n(), (double)startpos.func_177956_o(), (double)startpos.func_177952_p()), new Vector3d((double)endpos.func_177958_n(), (double)endpos.func_177956_o(), (double)endpos.func_177952_p()));
    }

    public static Vector3d getDirectionVecXZ(Vector3d startpos, Vector3d endpos) {
        double dx = endpos.field_72450_a - startpos.field_72450_a;
        double dz = endpos.field_72449_c - startpos.field_72449_c;
        double angle = Math.atan2(dz, dx);
        return DirectionUtils.getDirectionVecXZ(angle);
    }

    public static Vector3d getDirectionVecXZ(Entity entity1, Entity entity2) {
        Vector3d startpos = DirectionUtils.getPosVecForEntity(entity1);
        Vector3d endpos = DirectionUtils.getPosVecForEntity(entity2);
        return DirectionUtils.getDirectionVecXZ(startpos, endpos);
    }

    public static Vector3d getDirectionVecXZDegrees(double angle) {
        double rad = Math.toRadians(angle);
        return DirectionUtils.getDirectionVecXZ(rad);
    }

    public static Vector3d getDirectionVecXZ(double angle) {
        double x = Math.cos(angle);
        double z = Math.sin(angle);
        return new Vector3d(x, 0.0, z);
    }

    public static Vector3d getRandomDirectionVecXZ(Random rand) {
        int angle = rand.nextInt(360);
        return DirectionUtils.getDirectionVecXZDegrees(angle);
    }

    public static Vector3d getDirectionVec(Entity entity1, Entity entity2) {
        Vector3d startpos = DirectionUtils.getPosVecForEntity(entity1);
        Vector3d endpos = DirectionUtils.getPosVecForEntity(entity2);
        return DirectionUtils.getDirectionVec(startpos, endpos);
    }

    public static Vector3d getDirectionVec(Vector3i startpos, Vector3i endpos) {
        return DirectionUtils.getDirectionVec(new Vector3d((double)startpos.func_177958_n(), (double)startpos.func_177956_o(), (double)startpos.func_177952_p()), new Vector3d((double)endpos.func_177958_n(), (double)endpos.func_177956_o(), (double)endpos.func_177952_p()));
    }

    public static Vector3d getDirectionVec(Vector3d startpos, Vector3d endpos) {
        if (startpos.equals((Object)endpos)) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        double dx = endpos.field_72450_a - startpos.field_72450_a;
        double dy = endpos.field_72448_b - startpos.field_72448_b;
        double dz = endpos.field_72449_c - startpos.field_72449_c;
        double magnitude = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0) + Math.pow(dz, 2.0));
        double mx = (endpos.field_72450_a + startpos.field_72450_a) / magnitude;
        double my = (endpos.field_72448_b + startpos.field_72448_b) / magnitude;
        double mz = (endpos.field_72449_c + startpos.field_72449_c) / magnitude;
        return new Vector3d(mx, my, mz);
    }

    public static BlockPos getClosestLoadedPos(World world, BlockPos basepos, Vector3d direction, double radius) {
        BlockPos pos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, basepos.func_177963_a(direction.field_72450_a * radius, 0.0, direction.field_72449_c * radius));
        while (world.func_72863_F().func_225313_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) == null) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, basepos.func_177963_a(direction.field_72450_a * (radius -= 1.0), 0.0, direction.field_72449_c * radius));
        }
        return pos;
    }

    public static BlockPos getClosestLoadedPos(World world, BlockPos basepos, Vector3d direction, double radius, int maxlight, int minlight) {
        BlockPos pos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, basepos.func_177963_a(direction.field_72450_a * radius, 0.0, direction.field_72449_c * radius));
        while (world.func_72863_F().func_225313_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) == null || !DirectionUtils.isBrightnessAllowed(world, basepos, maxlight, minlight)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, basepos.func_177963_a(direction.field_72450_a * (radius -= 1.0), 0.0, direction.field_72449_c * radius));
        }
        return pos;
    }

    public static boolean isBrightnessAllowed(World world, BlockPos pos, int maxlight, int minlight) {
        int blocklight = world.func_217298_h(pos);
        if (blocklight > maxlight) {
            return false;
        }
        return blocklight >= minlight;
    }
}

