/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.data;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;

public class DataType<T extends Comparable<T>> {
    private static Map<String, DataType<?>> registry = new HashMap();
    public static DataType<Byte> BYTE = new DataType<Byte>("byte", Byte.class, json -> json.getAsByte(), (nbt, key) -> nbt.func_74771_c(key));
    public static DataType<Short> SHORT = new DataType<Short>("short", Short.class, json -> json.getAsShort(), (nbt, key) -> nbt.func_74765_d(key));
    public static DataType<Integer> INT = new DataType<Integer>("int", Integer.class, json -> json.getAsInt(), (nbt, key) -> nbt.func_74762_e(key));
    public static DataType<Long> LONG = new DataType<Long>("long", Long.class, json -> json.getAsLong(), (nbt, key) -> nbt.func_74763_f(key));
    public static DataType<Float> FLOAT = new DataType<Float>("float", Float.class, json -> Float.valueOf(json.getAsFloat()), (nbt, key) -> Float.valueOf(nbt.func_74760_g(key)));
    public static DataType<Double> DOUBLE = new DataType<Double>("double", Double.class, json -> json.getAsDouble(), (nbt, key) -> nbt.func_74769_h(key));
    public static DataType<String> STRING = new DataType<String>("string", String.class, json -> json.getAsString(), (nbt, key) -> nbt.func_74779_i(key));
    public static DataType<Boolean> BOOLEAN = new DataType<Boolean>("boolean", Boolean.class, json -> json.getAsBoolean(), (nbt, key) -> nbt.func_74767_n(key));
    private final String name;
    private final Class<T> clazz;
    private final Function<JsonElement, T> jsonReader;
    private final BiFunction<CompoundNBT, String, T> nbtReader;

    private DataType(String name, Class<T> clazz, Function<JsonElement, T> jsonReader, BiFunction<CompoundNBT, String, T> nbtReader) {
        this.name = name;
        this.clazz = clazz;
        this.jsonReader = jsonReader;
        this.nbtReader = nbtReader;
        registry.put(name, this);
    }

    public Class<T> getType() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isNumber() {
        return this != BOOLEAN && this != STRING;
    }

    public T cast(Comparable<?> value) {
        return (T)((Comparable)this.clazz.cast(value));
    }

    public T readFromJson(JsonElement element) {
        return (T)((Comparable)this.jsonReader.apply(element));
    }

    public T readFromNBT(CompoundNBT nbt, String key) {
        return (T)((Comparable)this.nbtReader.apply(nbt, key));
    }

    public static DataType<?> of(String name) {
        if (registry.containsKey(name)) {
            return registry.get(name);
        }
        return null;
    }

    public static DataType<?> of(Class<?> clazz) {
        for (DataType<?> type : registry.values()) {
            if (type.getType() != clazz) continue;
            return type;
        }
        return null;
    }
}

