/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ToolType;
import net.smileycorp.atlas.api.block.IBlockProperties;

public class BlockBase
extends Block
implements IBlockProperties {
    protected String name;
    protected final String modid;
    public boolean isFlamable;
    public ItemGroup tab;

    public BlockBase(String name, String modid, Material material, MaterialColor colour, SoundType sound, float h, float r, ToolType tool, int level, ItemGroup tab) {
        super(AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)colour).func_200948_a(h, r).harvestLevel(level).harvestTool(tool).func_200947_a(sound));
        this.setRegistryName(new ResourceLocation(modid, name.toLowerCase()));
        this.name = name;
        this.modid = modid;
        this.tab = tab;
        if (material == Material.field_151575_d) {
            this.isFlamable = true;
        }
    }

    public BlockBase(String name, String modid, Material material, MaterialColor colour, SoundType sound, float h, float r, int level, ItemGroup tab) {
        this(name, modid, material, null, sound, h, r, ToolType.PICKAXE, level, tab);
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.isFlamable ? 20 : super.getFlammability(state, world, pos, face);
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.isFlamable ? 5 : super.getFireSpreadSpeed(state, world, pos, face);
    }

    public IFormattableTextComponent func_235333_g_() {
        return new StringTextComponent(this.name);
    }

    public String getMod() {
        return this.modid;
    }

    public ItemGroup getCreativeTab() {
        return this.tab;
    }
}

