/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.schematic;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import com.natamus.collective.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;

public class Schematic {
    private int size;
    private short width;
    private short height;
    private short length;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private boolean oldVersion;
    private HashMap<Integer, String> palette;
    private SchematicBlockObject[] blockObjects;
    private List<CompoundNBT> blockEntities;
    private List<Pair<BlockPos, CompoundNBT>> entities;

    public Schematic(InputStream inputStream) {
        String type = "";
        try {
            CompoundNBT nbtdata = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            inputStream.close();
            if (nbtdata.func_74764_b("Length")) {
                this.length = nbtdata.func_74765_d("Length");
                this.width = nbtdata.func_74765_d("Width");
                this.height = nbtdata.func_74765_d("Height");
            } else {
                ListNBT sizeList = nbtdata.func_150295_c("size", 3);
                this.length = (short)sizeList.func_186858_c(0);
                this.width = (short)sizeList.func_186858_c(1);
                this.height = (short)sizeList.func_186858_c(2);
            }
            this.size = this.length * this.width * this.height;
            type = nbtdata.func_74764_b("entities") ? "nbt" : (nbtdata.func_74764_b("DataVersion") ? "schem" : "schematic");
            this.blockObjects = new SchematicBlockObject[this.size];
            this.entities = new ArrayList<Pair<BlockPos, CompoundNBT>>();
            if (type.equals("schem")) {
                byte[] blocks = nbtdata.func_74770_j("BlockData");
                CompoundNBT palette = nbtdata.func_74775_l("Palette");
                this.palette = new HashMap();
                for (String k : palette.func_150296_c()) {
                    this.palette.put(palette.func_74762_e(k), k);
                }
                int counter = 0;
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.length; ++j) {
                        for (int k = 0; k < this.width; ++k) {
                            BlockPos pos = new BlockPos(k, i, j);
                            int id = blocks[counter];
                            if (id < 0) {
                                id *= -1;
                            }
                            BlockState state = this.getStateFromID(id);
                            this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                            ++counter;
                        }
                    }
                }
                ListNBT tileentitynbtlist = nbtdata.func_150295_c("BlockEntities", 10);
                this.blockEntities = new ArrayList<CompoundNBT>();
                for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                    this.blockEntities.add(tileentitynbtlist.func_150305_b(i));
                }
                CompoundNBT offsetCompoundNBT = nbtdata.func_74775_l("Metadata");
                this.offsetX = offsetCompoundNBT.func_74762_e("WEOffsetX");
                this.offsetY = offsetCompoundNBT.func_74762_e("WEOffsetY");
                this.offsetZ = offsetCompoundNBT.func_74762_e("WEOffsetZ");
                return;
            }
            if (type.equals("schematic")) {
                byte[] blockIDs_byte = nbtdata.func_74770_j("Blocks");
                int[] blockIDs = new int[this.size];
                for (int x = 0; x < blockIDs_byte.length; ++x) {
                    blockIDs[x] = Byte.toUnsignedInt(blockIDs_byte[x]);
                }
                byte[] metadata = nbtdata.func_74770_j("Data");
                int counter = 0;
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.length; ++j) {
                        for (int k = 0; k < this.width; ++k) {
                            BlockPos pos = new BlockPos(k, i, j);
                            BlockState state = this.getStateFromOldIds(blockIDs[counter], metadata[counter]);
                            this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                            ++counter;
                        }
                    }
                }
                ListNBT tileentitynbtlist = nbtdata.func_150295_c("TileEntities", 10);
                this.blockEntities = new ArrayList<CompoundNBT>();
                for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                    CompoundNBT compound = tileentitynbtlist.func_150305_b(i);
                    int i0 = compound.func_74762_e("x");
                    int i1 = compound.func_74762_e("y");
                    int i2 = compound.func_74762_e("z");
                    compound.func_74783_a("Pos", new int[]{i0, i1, i2});
                    this.blockEntities.add(compound);
                }
                this.offsetX = nbtdata.func_74762_e("WEOffsetX");
                this.offsetY = nbtdata.func_74762_e("WEOffsetY");
                this.offsetZ = nbtdata.func_74762_e("WEOffsetZ");
                return;
            }
            if (type.equals("nbt")) {
                ListNBT paletteNBTList = nbtdata.func_150295_c("palette", 10);
                this.palette = new HashMap();
                for (int i = 0; i < paletteNBTList.size(); ++i) {
                    CompoundNBT compound = paletteNBTList.func_150305_b(i);
                    String value = compound.func_74779_i("Name");
                    if (compound.func_74764_b("Properties")) {
                        StringBuilder metaData = new StringBuilder("[");
                        CompoundNBT propertyCompound = compound.func_74775_l("Properties");
                        for (String propertyKey : propertyCompound.func_150296_c()) {
                            if (!metaData.toString().equals("[")) {
                                metaData.append(",");
                            }
                            metaData.append(propertyKey).append("=").append(propertyCompound.func_74781_a(propertyKey));
                        }
                        metaData.append("]");
                        value = value + metaData;
                    }
                    this.palette.put(i, value);
                }
                this.blockEntities = new ArrayList<CompoundNBT>();
                ListNBT blocksNBTList = nbtdata.func_150295_c("blocks", 10);
                for (int i = 0; i < blocksNBTList.size(); ++i) {
                    CompoundNBT compound = blocksNBTList.func_150305_b(i);
                    ListNBT posList = compound.func_150295_c("pos", 3);
                    int i0 = posList.func_186858_c(0);
                    int i1 = posList.func_186858_c(1);
                    int i2 = posList.func_186858_c(2);
                    BlockPos pos = new BlockPos(i0, i1, i2);
                    BlockState state = this.getStateFromID(compound.func_74762_e("state"));
                    this.blockObjects[i] = new SchematicBlockObject(pos, state);
                    if (!compound.func_74764_b("nbt")) continue;
                    CompoundNBT blockEntityCompound = compound.func_74775_l("nbt");
                    blockEntityCompound.func_74783_a("Pos", new int[]{i0, i1, i2});
                    blockEntityCompound.func_74778_a("Id", blockEntityCompound.func_74779_i("id"));
                    blockEntityCompound.func_82580_o("id");
                    this.blockEntities.add(blockEntityCompound);
                }
                ListNBT entitiesNBTList = nbtdata.func_150295_c("entities", 10);
                for (int i = 0; i < entitiesNBTList.size(); ++i) {
                    CompoundNBT compound = entitiesNBTList.func_150305_b(i);
                    CompoundNBT entityCompound = compound.func_74775_l("nbt");
                    ListNBT posList = compound.func_150295_c("blockPos", 3);
                    int i0 = posList.func_186858_c(0);
                    int i1 = posList.func_186858_c(1);
                    int i2 = posList.func_186858_c(2);
                    this.entities.add((Pair<BlockPos, CompoundNBT>)new Pair((Object)new BlockPos(i0, i1, i2), (Object)entityCompound));
                }
                this.offsetX = 0;
                this.offsetY = 0;
                this.offsetZ = 0;
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.err.println("Can't load " + type + " Schematic file.");
        this.width = 0;
        this.height = 0;
        this.length = 0;
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetZ = 0;
        this.size = 0;
        this.blockObjects = null;
        this.palette = null;
        this.blockEntities = null;
    }

    public boolean isOldVersion() {
        return this.oldVersion;
    }

    private BlockState getStateFromOldIds(int blockID, byte meta) {
        return Block.func_196257_b((int)blockID);
    }

    public BlockState getBlockState(BlockPos pos) {
        for (SchematicBlockObject obj : this.blockObjects) {
            if (!obj.getPosition().equals((Object)pos)) continue;
            return obj.getState();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public int getSize() {
        return this.size;
    }

    public SchematicBlockObject[] getBlocks() {
        return this.blockObjects;
    }

    public BlockState getStateFromID(int id) {
        String iblockstateS = this.palette.get(id);
        try {
            BlockStateParser parser = new BlockStateParser(new StringReader(iblockstateS), true);
            parser.func_197243_a(false);
            return parser.func_197249_b();
        }
        catch (Exception ex) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public List<CompoundNBT> getBlockEntities() {
        return this.blockEntities;
    }

    public List<Pair<BlockPos, CompoundNBT>> getEntityRelativePosPairs() {
        return this.entities;
    }

    public CompoundNBT getTileEntity(BlockPos pos) {
        for (CompoundNBT compound : this.blockEntities) {
            int[] pos1 = compound.func_74759_k("Pos");
            if (pos1[0] != pos.func_177958_n() || pos1[1] != pos.func_177956_o() || pos1[2] != pos.func_177952_p()) continue;
            return compound;
        }
        return null;
    }

    public BlockPos getBlockPosFromCompoundTag(CompoundNBT compoundTag) {
        int[] pos = compoundTag.func_74759_k("Pos");
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }
}

