/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.config.ConfigHandler;
import com.natamus.collective.data.GlobalVariables;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.entity.Entity;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class FABFunctions {
    private static final Map<Block, WeakHashMap<World, List<BlockPos>>> getMapFromBlock = new HashMap<Block, WeakHashMap<World, List<BlockPos>>>();
    private static final WeakHashMap<World, Map<Date, BlockPos>> timeoutpositions = new WeakHashMap();

    public static List<BlockPos> getAllTaggedTileEntityPositionsNearbyEntity(ITag.INamedTag<Block> tetag, Integer radius, World world, Entity entity) {
        return FABFunctions.getAllTaggedTileEntityPositionsNearbyPosition(tetag, radius, world, entity.func_233580_cy_());
    }

    public static List<BlockPos> getAllTaggedTileEntityPositionsNearbyPosition(ITag.INamedTag<Block> tetag, Integer radius, World world, BlockPos pos) {
        ArrayList<BlockPos> nearbypositions = new ArrayList<BlockPos>();
        for (TileEntity loadedtileentity : world.field_147482_g) {
            BlockPos ltepos;
            BlockState loadedtilestate = loadedtileentity.func_195044_w();
            if (loadedtilestate == null || !loadedtilestate.func_235714_a_(tetag) || !(ltepos = loadedtileentity.func_174877_v()).func_218141_a((Vector3i)pos, (double)radius.intValue())) continue;
            nearbypositions.add(loadedtileentity.func_174877_v());
        }
        return nearbypositions;
    }

    public static List<BlockPos> getAllTileEntityPositionsNearbyEntity(TileEntityType<?> tetype, Integer radius, World world, Entity entity) {
        return FABFunctions.getAllTileEntityPositionsNearbyPosition(tetype, radius, world, entity.func_233580_cy_());
    }

    public static List<BlockPos> getAllTileEntityPositionsNearbyPosition(TileEntityType<?> tetype, Integer radius, World world, BlockPos pos) {
        ArrayList<BlockPos> nearbypositions = new ArrayList<BlockPos>();
        for (TileEntity loadedtileentity : world.field_147482_g) {
            BlockPos ltepos;
            TileEntityType loadedtiletype = loadedtileentity.func_200662_C();
            if (loadedtiletype == null || !loadedtiletype.equals(tetype) || !(ltepos = loadedtileentity.func_174877_v()).func_218141_a((Vector3i)pos, (double)radius.intValue())) continue;
            nearbypositions.add(loadedtileentity.func_174877_v());
        }
        return nearbypositions;
    }

    /*
     * WARNING - void declaration
     */
    public static BlockPos getRequestedBlockAroundEntitySpawn(Block rawqueryblock, Integer radius, Double radiusmodifier, World world, Entity entity) {
        Map<Object, Object> timeouts;
        List<Object> currentblocks;
        Block requestedblock = FABFunctions.processCommonBlock(rawqueryblock);
        WeakHashMap<World, List<BlockPos>> worldblocks = FABFunctions.getMap(requestedblock);
        BlockPos epos = entity.func_233580_cy_();
        Vector3i removeblockpos = null;
        if (worldblocks.containsKey(world)) {
            currentblocks = worldblocks.get(world);
            ArrayList<BlockPos> cbtoremove = new ArrayList<BlockPos>();
            for (BlockPos blockPos : currentblocks) {
                if (!world.func_72863_F().func_73149_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4)) {
                    cbtoremove.add(blockPos);
                    continue;
                }
                if (!world.func_180495_p(blockPos).func_177230_c().equals(requestedblock)) {
                    cbtoremove.add(blockPos);
                    continue;
                }
                if (!blockPos.func_218141_a((Vector3i)epos, (double)radius.intValue() * radiusmodifier)) continue;
                return blockPos.func_185334_h();
            }
            if (cbtoremove.size() > 0) {
                for (BlockPos blockPos : cbtoremove) {
                    currentblocks.remove(blockPos);
                }
            }
        } else {
            currentblocks = new ArrayList();
        }
        if (timeoutpositions.containsKey(world)) {
            timeouts = timeoutpositions.get(world);
            ArrayList<Date> totoremove = new ArrayList<Date>();
            if (timeouts.size() > 0) {
                Date date = new Date();
                for (Date date2 : timeouts.keySet()) {
                    long ms;
                    BlockPos toepos = (BlockPos)timeouts.get(date2);
                    if (removeblockpos != null && toepos.func_218141_a(removeblockpos, 64.0)) {
                        totoremove.add(date2);
                    }
                    if ((ms = date.getTime() - date2.getTime()) > (long)((Integer)ConfigHandler.COLLECTIVE.findABlockcheckAroundEntitiesDelayMs.get()).intValue()) {
                        totoremove.add(date2);
                        continue;
                    }
                    if (!toepos.func_218141_a((Vector3i)epos, (double)radius.intValue() * radiusmodifier)) continue;
                    return null;
                }
            }
            if (totoremove.size() > 0) {
                for (Date date : totoremove) {
                    timeouts.remove(date);
                }
            }
        } else {
            timeouts = new HashMap();
        }
        if (GlobalVariables.blocksWithTileEntity.containsKey(requestedblock)) {
            TileEntityType<?> tiletypetofind = GlobalVariables.blocksWithTileEntity.get(requestedblock);
            List list = world.field_147482_g;
            for (TileEntity tileEntity : list) {
                BlockPos ltepos;
                TileEntityType loadedtiletype = tileEntity.func_200662_C();
                if (loadedtiletype == null || !loadedtiletype.equals(tiletypetofind) || !(ltepos = tileEntity.func_174877_v()).func_218141_a((Vector3i)epos, (double)radius.intValue() * radiusmodifier)) continue;
                currentblocks.add(ltepos.func_185334_h());
                worldblocks.put(world, currentblocks);
                getMapFromBlock.put(requestedblock, worldblocks);
                return ltepos.func_185334_h();
            }
        } else {
            void var12_22;
            int r = radius;
            int n = -r;
            while (var12_22 < r) {
                void var13_28;
                int n2 = -r;
                while (var13_28 < r) {
                    for (int i = -r; i < r; ++i) {
                        BlockPos cpos = epos.func_177965_g((int)var12_22).func_177964_d((int)var13_28).func_177981_b(i);
                        BlockState state = world.func_180495_p(cpos);
                        if (!state.func_177230_c().equals(requestedblock)) continue;
                        currentblocks.add(cpos.func_185334_h());
                        worldblocks.put(world, currentblocks);
                        getMapFromBlock.put(requestedblock, worldblocks);
                        return cpos.func_185334_h();
                    }
                    ++var13_28;
                }
                ++var12_22;
            }
        }
        timeouts.put(new Date(), epos.func_185334_h());
        timeoutpositions.put(world, timeouts);
        return null;
    }

    public static BlockPos updatePlacedBlock(Block requestedblock, BlockPos bpos, World world) {
        BlockState state = world.func_180495_p(bpos);
        if (state.func_177230_c().equals(requestedblock)) {
            WeakHashMap<World, List<BlockPos>> worldblocks = FABFunctions.getMap(requestedblock);
            List<Object> currentblocks = worldblocks.containsKey(world) ? worldblocks.get(world) : new ArrayList();
            if (!currentblocks.contains(bpos)) {
                currentblocks.add(bpos);
                worldblocks.put(world, currentblocks);
                getMapFromBlock.put(requestedblock, worldblocks);
            }
            return bpos;
        }
        return null;
    }

    private static WeakHashMap<World, List<BlockPos>> getMap(Block requestedblock) {
        WeakHashMap<Object, Object> worldblocks = getMapFromBlock.containsKey(requestedblock) ? getMapFromBlock.get(requestedblock) : new WeakHashMap();
        return worldblocks;
    }

    private static Block processCommonBlock(Block requestedblock) {
        Block blocktoreturn = requestedblock;
        if (requestedblock instanceof StandingSignBlock || requestedblock instanceof WallSignBlock) {
            blocktoreturn = Blocks.field_222384_bX;
        }
        return blocktoreturn;
    }
}

