/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.model;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MultipartBakedModel.class})
public class MixinMultipartBakedModel {
    private final Map<BlockState, IBakedModel[]> stateCacheFast = new Reference2ReferenceOpenHashMap();
    private final StampedLock lock = new StampedLock();
    @Shadow
    @Final
    private List<Pair<Predicate<BlockState>, IBakedModel>> field_188626_f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public List<BakedQuad> getQuads(BlockState state, Direction face, Random random, IModelData modelData) {
        IBakedModel[] models;
        if (state == null) {
            return Collections.emptyList();
        }
        long readStamp = this.lock.readLock();
        try {
            models = this.stateCacheFast.get(state);
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
        if (models == null) {
            long writeStamp = this.lock.writeLock();
            try {
                ArrayList<IBakedModel> modelList = new ArrayList<IBakedModel>(this.field_188626_f.size());
                for (Pair pair : this.field_188626_f) {
                    if (!((Predicate)pair.getLeft()).test(state)) continue;
                    modelList.add((IBakedModel)pair.getRight());
                }
                models = modelList.toArray(new IBakedModel[modelList.size()]);
                this.stateCacheFast.put(state, models);
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        long seed = random.nextLong();
        for (IBakedModel model : models) {
            random.setSeed(seed);
            quads.addAll(model.getQuads(state, face, random, modelData));
        }
        return quads;
    }
}

