/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.frustum;

import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClippingHelper.class})
public class MixinFrustum
implements FrustumExtended {
    private float xF;
    private float yF;
    private float zF;
    private float nxX;
    private float nxY;
    private float nxZ;
    private float nxW;
    private float pxX;
    private float pxY;
    private float pxZ;
    private float pxW;
    private float nyX;
    private float nyY;
    private float nyZ;
    private float nyW;
    private float pyX;
    private float pyY;
    private float pyZ;
    private float pyW;
    private float nzX;
    private float nzY;
    private float nzZ;
    private float nzW;
    private float pzX;
    private float pzY;
    private float pzZ;
    private float pzW;

    @Inject(method={"setPosition"}, at={@At(value="HEAD")})
    private void prePositionUpdate(double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        this.xF = (float)cameraX;
        this.yF = (float)cameraY;
        this.zF = (float)cameraZ;
    }

    @Inject(method={"transform"}, at={@At(value="HEAD")})
    private void transform(Matrix4f mat, int x, int y, int z, int index, CallbackInfo ci) {
        Vector4f vec = new Vector4f((float)x, (float)y, (float)z, 1.0f);
        vec.func_229372_a_(mat);
        vec.func_229374_e_();
        switch (index) {
            case 0: {
                this.nxX = vec.func_195910_a();
                this.nxY = vec.func_195913_b();
                this.nxZ = vec.func_195914_c();
                this.nxW = vec.func_195915_d();
                break;
            }
            case 1: {
                this.pxX = vec.func_195910_a();
                this.pxY = vec.func_195913_b();
                this.pxZ = vec.func_195914_c();
                this.pxW = vec.func_195915_d();
                break;
            }
            case 2: {
                this.nyX = vec.func_195910_a();
                this.nyY = vec.func_195913_b();
                this.nyZ = vec.func_195914_c();
                this.nyW = vec.func_195915_d();
                break;
            }
            case 3: {
                this.pyX = vec.func_195910_a();
                this.pyY = vec.func_195913_b();
                this.pyZ = vec.func_195914_c();
                this.pyW = vec.func_195915_d();
                break;
            }
            case 4: {
                this.nzX = vec.func_195910_a();
                this.nzY = vec.func_195913_b();
                this.nzZ = vec.func_195914_c();
                this.nzW = vec.func_195915_d();
                break;
            }
            case 5: {
                this.pzX = vec.func_195910_a();
                this.pzY = vec.func_195913_b();
                this.pzZ = vec.func_195914_c();
                this.pzW = vec.func_195915_d();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    @Override
    public boolean fastAabbTest(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return this.func_228954_a_(minX - this.xF, minY - this.yF, minZ - this.zF, maxX - this.xF, maxY - this.yF, maxZ - this.zF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Overwrite
    private boolean func_228954_a_(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        float f = this.nxX * (this.nxX < 0.0f ? minX : maxX) + this.nxY * (this.nxY < 0.0f ? minY : maxY);
        float f2 = this.nxZ < 0.0f ? minZ : maxZ;
        if (!(f + this.nxZ * f2 >= -this.nxW)) return false;
        float f3 = this.pxX * (this.pxX < 0.0f ? minX : maxX) + this.pxY * (this.pxY < 0.0f ? minY : maxY);
        float f4 = this.pxZ < 0.0f ? minZ : maxZ;
        if (!(f3 + this.pxZ * f4 >= -this.pxW)) return false;
        float f5 = this.nyX * (this.nyX < 0.0f ? minX : maxX) + this.nyY * (this.nyY < 0.0f ? minY : maxY);
        float f6 = this.nyZ < 0.0f ? minZ : maxZ;
        if (!(f5 + this.nyZ * f6 >= -this.nyW)) return false;
        float f7 = this.pyX * (this.pyX < 0.0f ? minX : maxX) + this.pyY * (this.pyY < 0.0f ? minY : maxY);
        float f8 = this.pyZ < 0.0f ? minZ : maxZ;
        if (!(f7 + this.pyZ * f8 >= -this.pyW)) return false;
        float f9 = this.nzX * (this.nzX < 0.0f ? minX : maxX) + this.nzY * (this.nzY < 0.0f ? minY : maxY);
        float f10 = this.nzZ < 0.0f ? minZ : maxZ;
        if (!(f9 + this.nzZ * f10 >= -this.nzW)) return false;
        float f11 = this.pzX * (this.pzX < 0.0f ? minX : maxX) + this.pzY * (this.pzY < 0.0f ? minY : maxY);
        float f12 = this.pzZ < 0.0f ? minZ : maxZ;
        if (!(f11 + this.pzZ * f12 >= -this.pzW)) return false;
        return true;
    }
}

