/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import me.jellysquid.mods.sodium.client.gl.compat.FogHelper;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import org.lwjgl.opengl.GL20C;

public abstract class ChunkShaderFogComponent {
    public abstract void setup();

    public static class Linear
    extends ChunkShaderFogComponent {
        private final int uFogColor;
        private final int uFogLength;
        private final int uFogEnd;

        public Linear(ChunkProgram program) {
            this.uFogColor = program.getUniformLocation("u_FogColor");
            this.uFogLength = program.getUniformLocation("u_FogLength");
            this.uFogEnd = program.getUniformLocation("u_FogEnd");
        }

        @Override
        public void setup() {
            float end = FogHelper.getFogEnd();
            float start = FogHelper.getFogStart();
            float[] color = FogHelper.getFogColor();
            GL20C.glUniform4fv((int)this.uFogColor, (float[])color);
            GL20C.glUniform1f((int)this.uFogLength, (float)(end - start));
            GL20C.glUniform1f((int)this.uFogEnd, (float)end);
        }
    }

    public static class Exp2
    extends ChunkShaderFogComponent {
        private final int uFogColor;
        private final int uFogDensity;

        public Exp2(ChunkProgram program) {
            this.uFogColor = program.getUniformLocation("u_FogColor");
            this.uFogDensity = program.getUniformLocation("u_FogDensity");
        }

        @Override
        public void setup() {
            GL20C.glUniform4fv((int)this.uFogColor, (float[])FogHelper.getFogColor());
            GL20C.glUniform1f((int)this.uFogDensity, (float)FogHelper.getFogDensity());
        }
    }

    public static class None
    extends ChunkShaderFogComponent {
        public None(ChunkProgram program) {
        }

        @Override
        public void setup() {
        }
    }
}

